/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultimapFileReader
extends Reader {
    private BufferedReader reader;

    public MultimapFileReader(BufferedReader reader) {
        this.reader = reader;
    }

    public Map<String, List<String>> readMultimap() throws IOException {
        HashMap<String, List<String>> multimap = new HashMap<String, List<String>>();
        String line = this.reader.readLine();
        while (line != null) {
            String[] keyValue = line.split("=");
            String term = keyValue[0];
            String[] values = keyValue[1].split("\\|");
            ArrayList<String> valueList = new ArrayList<String>();
            for (String hypernym : values) {
                valueList.add(hypernym);
            }
            multimap.put(term, valueList);
            line = this.reader.readLine();
        }
        return multimap;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }
}

