/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class UpperCaseFilter
extends TokenFilter {
    private TokenStream input;

    public UpperCaseFilter(TokenStream input) {
        super(input);
        this.input = input;
    }

    public Token next(Token inputToken) throws IOException {
        Token nextToken = this.input.next(inputToken);
        if (nextToken == null) {
            return null;
        }
        String termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
        termText = termText.toUpperCase();
        nextToken.setTermBuffer(termText.toCharArray(), 0, termText.length());
        return nextToken;
    }

    public void reset() throws IOException {
        this.input.reset();
    }
}

