/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenStreamConcatenator
extends TokenStream {
    private Collection<TokenStream> tokenStreams;
    private Iterator<TokenStream> tokenStreamIterator;
    private TokenStream currentTokenStream;

    public TokenStreamConcatenator(Collection<TokenStream> tokenStreams) {
        this.tokenStreams = tokenStreams;
        this.tokenStreamIterator = tokenStreams.iterator();
        if (this.tokenStreamIterator.hasNext()) {
            this.currentTokenStream = this.tokenStreamIterator.next();
        }
    }

    public Token next(Token inputToken) throws IOException {
        if (this.currentTokenStream == null) {
            if (this.tokenStreamIterator.hasNext()) {
                this.currentTokenStream = this.tokenStreamIterator.next();
            } else {
                return null;
            }
        }
        Token nextToken = this.currentTokenStream.next(inputToken);
        while (nextToken == null) {
            if (this.tokenStreamIterator.hasNext()) {
                this.currentTokenStream = this.tokenStreamIterator.next();
                nextToken = this.currentTokenStream.next(inputToken);
                continue;
            }
            return null;
        }
        return nextToken;
    }

    public void reset() throws IOException {
        for (TokenStream tokenStream : this.tokenStreams) {
            tokenStream.reset();
        }
        this.tokenStreamIterator = this.tokenStreams.iterator();
        this.currentTokenStream = this.tokenStreamIterator.hasNext() ? this.tokenStreamIterator.next() : null;
    }
}

