/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class SplitterFilter
extends TokenFilter {
    private String splitString;
    private Iterator<String> splitIterator;
    private Token currentToken;

    public SplitterFilter(TokenStream input, String splitString) {
        super(input);
        this.splitString = splitString;
        this.splitIterator = Iterators.emptyIterator();
    }

    public Token next(Token token) throws IOException {
        if (!this.splitIterator.hasNext()) {
            this.currentToken = this.input.next(token);
            if (this.currentToken == null) {
                return null;
            }
            String tokenText = new String(this.currentToken.termBuffer(), 0, this.currentToken.termLength());
            Object[] splitts = tokenText.split(this.splitString);
            this.splitIterator = Iterators.forArray((Object[])splitts, (int)0, (int)splitts.length);
        }
        if (!this.splitIterator.hasNext()) {
            return null;
        }
        token.setStartOffset(this.currentToken.startOffset());
        token.setEndOffset(this.currentToken.endOffset());
        char[] termBuffer = this.splitIterator.next().toCharArray();
        token.setTermBuffer(termBuffer, 0, termBuffer.length);
        return token;
    }

    public Token next() throws IOException {
        return this.next(new Token());
    }

    public String getSplitString() {
        return this.splitString;
    }
}

