/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.analysis.ReplaceFilter;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.util.MapFileReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceFilterFactory
implements TokenFilterFactory {
    public static final String FILE_PATH_PARAMETER = "filePath";
    private MapFileReaderFactory mapFileReaderFactory;
    private Map<String, Map<String, String>> cachedMappings;
    private static Logger LOGGER = Logger.getLogger(ReplaceFilterFactory.class);

    public ReplaceFilterFactory(MapFileReaderFactory mapFileReaderFactory) {
        this.mapFileReaderFactory = mapFileReaderFactory;
        this.cachedMappings = new HashMap<String, Map<String, String>>();
    }

    @Override
    public TokenFilter createTokenFilter(TokenStream tokenStream, Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        return new ReplaceFilter(tokenStream, this.getMapping(filePath));
    }

    @Override
    public void preloadResources(Properties properties) throws IOException {
        String filePath = properties.getProperty(FILE_PATH_PARAMETER);
        Map<String, String> mapping = this.getMapping(filePath);
    }

    public Map<String, String> getMapping(String filePath) throws IOException {
        Map<String, String> mapping = this.cachedMappings.get(filePath);
        if (mapping == null) {
            mapping = this.mapFileReaderFactory.createMapFileReader(filePath).readMap();
            LOGGER.info((Object)("file " + filePath + " loaded with " + mapping.size() + " entries"));
            this.cachedMappings.put(filePath, mapping);
        }
        return mapping;
    }

    Map<String, Map<String, String>> getCachedMappings() {
        return this.cachedMappings;
    }
}

