/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceFilter
extends TokenFilter {
    private TokenStream input;
    private Map<String, String> mapping;

    public ReplaceFilter(TokenStream input, Map<String, String> mapping) {
        super(input);
        this.input = input;
        this.mapping = mapping;
    }

    public Token next(Token inputToken) throws IOException {
        Token token = this.input.next(inputToken);
        if (token == null) {
            return null;
        }
        String termText = new String(token.termBuffer(), 0, token.termLength());
        String replaceText = this.mapping.get(termText);
        if (replaceText != null) {
            token.setTermBuffer(replaceText.toCharArray(), 0, replaceText.length());
        }
        return token;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }
}

