/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public class ConcatFilter
extends TokenFilter {
    private int startOffset;
    private String concatString;
    private Token lastToken;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    protected ConcatFilter(TokenStream input, String concatString) {
        super(input);
        this.concatString = concatString;
        this.startOffset = -1;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        StringBuffer result = new StringBuffer();
        TermAttribute inputTermAtt = (TermAttribute)this.input.getAttribute(TermAttribute.class);
        OffsetAttribute inputOffsetAtt = (OffsetAttribute)this.input.getAttribute(OffsetAttribute.class);
        int endOffset = -1;
        int startOffset = -1;
        if (this.input.incrementToken()) {
            startOffset = inputOffsetAtt.startOffset();
            result.append(inputTermAtt.term());
            while (this.input.incrementToken()) {
                result.append(this.concatString);
                result.append(inputTermAtt.term());
                endOffset = inputOffsetAtt.endOffset();
            }
            this.termAtt.setTermBuffer(result.toString());
            this.offsetAtt.setOffset(startOffset, endOffset);
            return true;
        }
        return false;
    }

    @Deprecated
    public Token next(Token reusableToken) throws IOException {
        String tokenText = this.concatenatedInputTokenTerms(reusableToken);
        reusableToken.setTermBuffer(tokenText.toCharArray(), 0, tokenText.length());
        reusableToken.setStartOffset(this.startOffset);
        reusableToken.setEndOffset(this.lastToken.endOffset());
        return reusableToken;
    }

    @Deprecated
    private String concatenatedInputTokenTerms(Token reusableToken) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Token nextToken = this.input.next(reusableToken);
        this.lastToken = null;
        if (this.startOffset == -1) {
            this.startOffset = nextToken.startOffset();
        }
        while (nextToken != null) {
            this.lastToken = nextToken;
            stringBuffer.append(nextToken.term());
            nextToken = this.input.next(reusableToken);
            if (nextToken == null) continue;
            stringBuffer.append(this.concatString);
        }
        return stringBuffer.toString();
    }

    protected String getConcatString() {
        return this.concatString;
    }
}

