/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.lucas.indexer.analysis.InvalidTokenSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTokenStream
extends TokenStream {
    private JCas jCas;
    private String featurePath;
    private List<String> featureNames;
    private String delimiter;
    private Iterator<Annotation> annotationIterator;
    private Iterator<FeatureStructure> featureStructureIterator;
    private Iterator<String> featureValueIterator;
    private Annotation currentAnnotation;
    private Type annotationType;
    private Map<String, Format> featureFormats;
    private static Logger logger = Logger.getLogger(AnnotationTokenStream.class);

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName) throws InvalidTokenSourceException {
        this(jCas, sofaName, typeName, null, Collections.emptyList(), null, Collections.emptyMap());
    }

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName, String featureName, Format featureFormat) throws InvalidTokenSourceException {
        this(jCas, sofaName, typeName, null, Lists.newArrayList((Object[])new String[]{featureName}), null, (Map<String, Format>)(featureFormat != null ? ImmutableBiMap.of((Object)featureName, (Object)featureFormat) : Collections.emptyMap()));
    }

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName, List<String> featureNames, String delimiter, Map<String, Format> featureFormats) throws InvalidTokenSourceException {
        this(jCas, sofaName, typeName, null, featureNames, delimiter, featureFormats);
    }

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName, List<String> featureNames, Map<String, Format> featureFormats) throws InvalidTokenSourceException {
        this(jCas, sofaName, typeName, null, featureNames, null, featureFormats);
    }

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName, String featurePath, List<String> featureNames, Map<String, Format> featureFormats) throws InvalidTokenSourceException {
        this(jCas, sofaName, typeName, featurePath, featureNames, null, featureFormats);
    }

    public AnnotationTokenStream(JCas jCas, String sofaName, String typeName, String featurePath, List<String> featureNames, String delimiter, Map<String, Format> featureFormats) throws InvalidTokenSourceException {
        this.featurePath = featurePath;
        this.featureNames = featureNames;
        this.delimiter = delimiter;
        this.featureFormats = featureFormats == null ? Collections.emptyMap() : featureFormats;
        this.getSofaCas(jCas, sofaName);
        this.getTypeForName(typeName);
        this.validate(this.annotationType, featureNames, featurePath);
        this.initializeIterators();
    }

    private void getTypeForName(String typeName) throws InvalidTokenSourceException {
        this.annotationType = this.jCas.getTypeSystem().getType(typeName);
        if (this.annotationType == null) {
            throw new InvalidTokenSourceException("Type " + typeName + " not found!");
        }
    }

    private void getSofaCas(JCas cas, String sofaName) throws InvalidTokenSourceException {
        try {
            this.jCas = cas.getView(sofaName);
        }
        catch (CASException e) {
            throw new InvalidTokenSourceException(e);
        }
    }

    void validate(Type type, Collection<String> featureNames, String featurePath) throws InvalidTokenSourceException {
        Type typeToValidate = this.findTypeWithPath(type, featurePath);
        for (String featureName : featureNames) {
            Feature feature = typeToValidate.getFeatureByBaseName(featureName);
            if (feature != null) continue;
            throw new InvalidTokenSourceException("Type " + typeToValidate.getName() + " has no feature " + featureName + ". featurePath: " + featurePath);
        }
    }

    private Type findTypeWithPath(Type type, String featurePath) throws InvalidTokenSourceException {
        if (featurePath == null) {
            return type;
        }
        String[] featurePathElements = featurePath.split("\\.");
        Type currentType = type;
        for (String featurePathElement : featurePathElements) {
            Feature feature = currentType.getFeatureByBaseName(featurePathElement);
            if (feature == null) {
                throw new InvalidTokenSourceException("Type " + currentType.getName() + " has no feature " + featurePathElement);
            }
            currentType = feature.getRange();
            if (!currentType.isArray()) continue;
            currentType = currentType.getComponentType();
        }
        return currentType;
    }

    public Token next(Token token) throws IOException {
        while (!this.featureValueIterator.hasNext()) {
            while (!this.featureStructureIterator.hasNext()) {
                if (!this.annotationIterator.hasNext()) {
                    return null;
                }
                this.currentAnnotation = this.annotationIterator.next();
                this.featureStructureIterator = this.createFeatureStructureIterator(this.currentAnnotation, this.featurePath);
            }
            this.featureValueIterator = this.createFeatureValueIterator(this.featureStructureIterator.next(), this.featureNames);
        }
        token.setStartOffset(this.currentAnnotation.getBegin());
        token.setEndOffset(this.currentAnnotation.getEnd());
        char[] value = this.featureValueIterator.next().toCharArray();
        token.setTermBuffer(value, 0, value.length);
        return token;
    }

    public Token next() throws IOException {
        return this.next(new Token());
    }

    protected void initializeIterators() {
        this.annotationIterator = Iterators.filter((Iterator)this.jCas.getAnnotationIndex(this.annotationType).iterator(), new NotNullPredicate());
        if (!this.annotationIterator.hasNext()) {
            this.featureStructureIterator = Iterators.emptyIterator();
            this.featureValueIterator = Iterators.emptyIterator();
            return;
        }
        this.currentAnnotation = this.annotationIterator.next();
        this.featureStructureIterator = this.createFeatureStructureIterator(this.currentAnnotation, this.featurePath);
        if (!this.featureStructureIterator.hasNext()) {
            this.featureValueIterator = Iterators.emptyIterator();
            return;
        }
        FeatureStructure featureStructure = this.featureStructureIterator.next();
        this.featureValueIterator = this.createFeatureValueIterator(featureStructure, this.featureNames);
    }

    protected Iterator<FeatureStructure> createFeatureStructureIterator(Annotation annotation, String featurePath) {
        LinkedList<Object> featureStructures = new LinkedList<Object>();
        LinkedList<FeatureStructure> childs = new LinkedList<FeatureStructure>();
        if (featurePath == null) {
            featureStructures.add(annotation);
            return featureStructures.iterator();
        }
        Type currentType = annotation.getType();
        if (currentType.isArray()) {
            currentType = currentType.getComponentType();
        }
        String[] pathEntries = featurePath.split("\\.");
        featureStructures.add(annotation);
        for (String pathEntry : pathEntries) {
            Feature feature = currentType.getFeatureByBaseName(pathEntry);
            childs.clear();
            if (feature.getRange().isArray()) {
                for (FeatureStructure featureStructure : featureStructures) {
                    FSArray fsArray = (FSArray)featureStructure.getFeatureValue(feature);
                    if (fsArray == null) continue;
                    for (int i = 0; i < fsArray.size(); ++i) {
                        childs.add(fsArray.get(i));
                    }
                }
            } else {
                for (FeatureStructure featureStructure : featureStructures) {
                    childs.add(featureStructure.getFeatureValue(feature));
                }
            }
            if ((currentType = feature.getRange()).isArray()) {
                currentType = currentType.getComponentType();
            }
            featureStructures.clear();
            featureStructures.addAll(childs);
        }
        return Iterators.filter(featureStructures.iterator(), new NotNullPredicate());
    }

    protected Iterator<String> createFeatureValueIterator(FeatureStructure srcFeatureStructure, Collection<String> featureNames) {
        LinkedList<String> values = new LinkedList<String>();
        Type featureType = srcFeatureStructure.getType();
        if (featureNames.size() == 0) {
            values.add(this.currentAnnotation.getCoveredText());
        }
        for (String featureName : featureNames) {
            Feature feature = featureType.getFeatureByBaseName(featureName);
            if (feature.getRange().isArray()) {
                StringArray fsArray = (StringArray)srcFeatureStructure.getFeatureValue(feature);
                if (featureNames.size() == 1) {
                    for (int i = 0; i < fsArray.size(); ++i) {
                        values.add(fsArray.get(i).toString());
                    }
                    continue;
                }
                String value = "";
                for (int i = 0; i < fsArray.size(); ++i) {
                    value = value.concat(fsArray.get(i).toString());
                    if (i >= fsArray.size() - 1) continue;
                    value = value.concat(this.delimiter);
                }
                values.add(value);
                continue;
            }
            values.add(this.getValueForFeature(srcFeatureStructure, feature, this.featureFormats.get(feature.getShortName())));
        }
        String value = "";
        if (this.delimiter != null) {
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i) == null) continue;
                value = value.concat((String)values.get(i));
                if (i >= values.size() - 1) continue;
                value = value.concat(this.delimiter);
            }
            values.clear();
            values.add(value);
        }
        return Iterators.filter(values.iterator(), new NotNullPredicate());
    }

    public String getValueForFeature(FeatureStructure featureStructure, Feature feature, Format format) {
        if (format == null) {
            return featureStructure.getFeatureValueAsString(feature);
        }
        Number value = null;
        if (feature.getRange().getName().equals("uima.cas.Double")) {
            value = featureStructure.getDoubleValue(feature);
        } else if (feature.getRange().getName().equals("uima.cas.Float")) {
            value = Float.valueOf(featureStructure.getFloatValue(feature));
        } else if (feature.getRange().getName().equals("uima.cas.Long")) {
            value = featureStructure.getLongValue(feature);
        } else if (feature.getRange().getName().equals("uima.cas.Integer")) {
            value = featureStructure.getIntValue(feature);
        } else if (feature.getRange().getName().equals("uima.cas.Short")) {
            value = featureStructure.getShortValue(feature);
        }
        return format.format(value);
    }

    public void reset() {
        this.featureStructureIterator = null;
        this.currentAnnotation = null;
        this.featureFormats = Collections.emptyMap();
        this.initializeIterators();
    }

    public Map<String, Format> getFeatureFormats() {
        return this.featureFormats;
    }

    public JCas getJCas() {
        return this.jCas;
    }

    public String getFeaturePath() {
        return this.featurePath;
    }

    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public Type getAnnotationType() {
        return this.annotationType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotNullPredicate<T>
    implements Predicate<T> {
        private NotNullPredicate() {
        }

        public boolean apply(T object) {
            return object != null;
        }
    }
}

