/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class AdditionFilter
extends TokenFilter {
    public static final Integer PREFIX = 0;
    public static final Integer POSTFIX = 1;
    private Integer position;
    private String addition;

    public AdditionFilter(TokenStream input, String addition, Integer position) {
        super(input);
        this.position = position;
        this.addition = addition;
    }

    public Token next(Token aToken) throws IOException {
        Token token = this.input.next(aToken);
        if (token == null) {
            return null;
        }
        String tokenText = new String(token.termBuffer(), 0, token.termLength());
        tokenText = this.position.equals(PREFIX) ? this.addition.concat(tokenText) : tokenText.concat(this.addition);
        token.setTermBuffer(tokenText.toCharArray(), 0, tokenText.length());
        return token;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getAddition() {
        return this.addition;
    }
}

