/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas.indexer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.uima.lucas.indexer.FilterBuildingException;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.mapping.FilterDescription;
import org.apache.uima.lucas.indexer.mapping.Locateable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterBuilder {
    public static final Logger LOGGER = Logger.getLogger(FilterBuilder.class);
    private Map<String, TokenFilterFactory> cachedFactories;
    private Locateable currentLocateable;

    public FilterBuilder(Map<String, TokenFilterFactory> predefinedFactories) {
        this.cachedFactories = predefinedFactories;
    }

    public TokenStream filter(TokenStream tokenStream, Collection<FilterDescription> filterDescriptions) throws FilterBuildingException {
        TokenStream filteredTokenStream = tokenStream;
        for (FilterDescription filterDescription : filterDescriptions) {
            TokenFilterFactory tokenFilterFactory;
            String filterName = filterDescription.getName();
            String factoryClassName = filterDescription.getFactoryClassName();
            String className = filterDescription.getClassName();
            this.currentLocateable = filterDescription;
            if (filterName != null && factoryClassName == null) {
                tokenFilterFactory = this.cachedFactories.get(filterName);
                if (tokenFilterFactory == null) {
                    throw this.createException("No factory registered for " + filterName + ". Please provide a factory");
                }
                filteredTokenStream = this.createTokenFilter(filteredTokenStream, filterDescription, tokenFilterFactory);
                continue;
            }
            if (className != null) {
                filteredTokenStream = this.createTokenFilterWithClassName(filteredTokenStream, className);
                continue;
            }
            if (factoryClassName == null) continue;
            tokenFilterFactory = this.createTokenFilterFactory(factoryClassName);
            filteredTokenStream = this.createTokenFilter(filteredTokenStream, filterDescription, tokenFilterFactory);
            if (!filterDescription.isReuseFactory()) continue;
            if (filterName == null) {
                throw this.createException("Provide a name for factory reuse ");
            }
            this.cachedFactories.put(filterName, tokenFilterFactory);
        }
        return filteredTokenStream;
    }

    private TokenFilter createTokenFilter(TokenStream filteredTokenStream, FilterDescription filterDescription, TokenFilterFactory tokenFilterFactory) throws FilterBuildingException {
        try {
            return tokenFilterFactory.createTokenFilter(filteredTokenStream, filterDescription.getProperties());
        }
        catch (IOException e) {
            throw this.createException("Can't build filter with description", e);
        }
    }

    private TokenFilterFactory createTokenFilterFactory(String factoryClassName) throws FilterBuildingException {
        try {
            Constructor<?>[] constructors;
            Class<?> clazz = Class.forName(factoryClassName);
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                Class<?>[] parameters = constructor.getParameterTypes();
                if (parameters.length != 0) continue;
                return (TokenFilterFactory)constructor.newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            throw this.createException("Can't instantiate TokenFilterFactory " + factoryClassName);
        }
        catch (IllegalArgumentException e) {
            throw this.createException("Can't instantiate TokenFilterFactory " + factoryClassName);
        }
        catch (InstantiationException e) {
            throw this.createException("Can't instantiate TokenFilterFactory " + factoryClassName);
        }
        catch (IllegalAccessException e) {
            throw this.createException("Can't instantiate TokenFilterFactory " + factoryClassName);
        }
        catch (InvocationTargetException e) {
            throw this.createException("Can't instantiate TokenFilterFactory " + factoryClassName);
        }
        throw new FilterBuildingException("Class " + factoryClassName + " has no public no argument constructor!");
    }

    private TokenFilter createTokenFilterWithClassName(TokenStream tokenStream, String className) throws FilterBuildingException {
        try {
            Constructor<?>[] constructors;
            Class<?> clazz = Class.forName(className);
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                Class<?>[] parameters = constructor.getParameterTypes();
                if (parameters.length != 1 || !parameters[0].equals(TokenStream.class)) continue;
                return (TokenFilter)constructor.newInstance(tokenStream);
            }
        }
        catch (ClassNotFoundException e) {
            throw new FilterBuildingException("Can't instantiate TokenFilter " + className, e);
        }
        catch (IllegalArgumentException e) {
            throw new FilterBuildingException("Can't instantiate TokenFilter " + className, e);
        }
        catch (InstantiationException e) {
            throw new FilterBuildingException("Can't instantiate TokenFilter " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new FilterBuildingException("Can't instantiate TokenFilter " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new FilterBuildingException("Can't instantiate TokenFilter " + className, e);
        }
        throw this.createException("Class " + className + " has no public single argument constructor!");
    }

    private FilterBuildingException createException(String message, Throwable cause) {
        String extendedMessage = message + " at line " + this.currentLocateable.getLineNumber();
        return new FilterBuildingException(extendedMessage, cause);
    }

    private FilterBuildingException createException(String message) {
        String extendedMessage = message + " at line " + this.currentLocateable.getLineNumber();
        return new FilterBuildingException(extendedMessage);
    }

    Map<String, TokenFilterFactory> getCachedFactories() {
        return this.cachedFactories;
    }
}

