/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.lucas;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.lucas.indexer.AnnotationTokenStreamBuilder;
import org.apache.uima.lucas.indexer.AnnotationTokenStreamBuildingException;
import org.apache.uima.lucas.indexer.DocumentBuilder;
import org.apache.uima.lucas.indexer.FieldBuilder;
import org.apache.uima.lucas.indexer.FieldBuildingException;
import org.apache.uima.lucas.indexer.FilterBuilder;
import org.apache.uima.lucas.indexer.FilterBuildingException;
import org.apache.uima.lucas.indexer.Tokenizer;
import org.apache.uima.lucas.indexer.analysis.AnnotationTokenStream;
import org.apache.uima.lucas.indexer.analysis.DefaultFilterFactoryRegistry;
import org.apache.uima.lucas.indexer.analysis.TokenFilterFactory;
import org.apache.uima.lucas.indexer.mapping.AnnotationDescription;
import org.apache.uima.lucas.indexer.mapping.AnnotationMapper;
import org.apache.uima.lucas.indexer.mapping.FeatureMapper;
import org.apache.uima.lucas.indexer.mapping.FieldDescription;
import org.apache.uima.lucas.indexer.mapping.FieldMapper;
import org.apache.uima.lucas.indexer.mapping.FilterDescription;
import org.apache.uima.lucas.indexer.mapping.FilterMapper;
import org.apache.uima.lucas.indexer.mapping.MappingFileReader;
import org.apache.uima.resource.ResourceInitializationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LuceneDocumentAE
extends CasAnnotator_ImplBase {
    private static final Logger log = Logger.getLogger(LuceneDocumentAE.class);
    public static final String PARAM_MAPPINGFILE = "mappingFile";
    protected Collection<FieldDescription> fieldDescriptions;
    private DocumentBuilder documentBuilder;
    protected FieldBuilder fieldBuilder;
    protected FilterBuilder filterBuilder;
    protected AnnotationTokenStreamBuilder annotationTokenStreamBuilder;
    protected Tokenizer tokenizer;
    private Map<String, TokenFilterFactory> defaultFilterFactoryRegistry;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.createFieldDescriptions();
        this.createFilterBuilderWithPreloadedResources();
        this.annotationTokenStreamBuilder = new AnnotationTokenStreamBuilder();
        this.tokenizer = new Tokenizer();
        this.fieldBuilder = new FieldBuilder(this.filterBuilder);
        this.documentBuilder = new DocumentBuilder();
    }

    private void createFieldDescriptions() throws ResourceInitializationException {
        String mappingFilePath = (String)this.getContext().getConfigParameterValue(PARAM_MAPPINGFILE);
        try {
            MappingFileReader indexMappingFileReader = this.createMappingFileReader();
            File mappingFile = new File(mappingFilePath);
            this.fieldDescriptions = indexMappingFileReader.readFieldDescriptionsFromFile(mappingFile);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private MappingFileReader createMappingFileReader() throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            HashMap elementMappers = new HashMap();
            elementMappers.put("annotation", new AnnotationMapper());
            elementMappers.put("filter", new FilterMapper());
            elementMappers.put("field", new FieldMapper());
            elementMappers.put("feature", new FeatureMapper());
            return new MappingFileReader(parser, elementMappers);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Can't build SAXParser: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("Can't build SAXParser: " + e.getMessage());
        }
    }

    private void createFilterBuilderWithPreloadedResources() throws ResourceInitializationException {
        this.defaultFilterFactoryRegistry = new DefaultFilterFactoryRegistry().getDefaultRegistry();
        try {
            this.preloadResources(this.fieldDescriptions, this.defaultFilterFactoryRegistry);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.filterBuilder = new FilterBuilder(this.defaultFilterFactoryRegistry);
    }

    protected void preloadResources(Collection<FieldDescription> fieldDescriptions, Map<String, TokenFilterFactory> defaultFilterFactoryRegistry) throws IOException {
        for (FieldDescription fieldDescription : fieldDescriptions) {
            for (FilterDescription filterDescription : fieldDescription.getFilterDescriptions()) {
                TokenFilterFactory tokenFilterFactory = defaultFilterFactoryRegistry.get(filterDescription.getName());
                if (tokenFilterFactory == null) continue;
                tokenFilterFactory.preloadResources(filterDescription.getProperties());
            }
            for (AnnotationDescription annotationDescription : fieldDescription.getAnnotationDescriptions()) {
                for (FilterDescription filterDescription : annotationDescription.getFilterDescriptions()) {
                    TokenFilterFactory tokenFilterFactory = defaultFilterFactoryRegistry.get(filterDescription.getName());
                    if (tokenFilterFactory == null) continue;
                    tokenFilterFactory.preloadResources(filterDescription.getProperties());
                }
            }
        }
    }

    public Document createDocument(CAS cas) throws AnalysisEngineProcessException {
        try {
            JCas jCas = cas.getJCas();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (FieldDescription fieldDescription : this.fieldDescriptions) {
                ArrayList<TokenStream> tokenStreams = new ArrayList<TokenStream>();
                for (AnnotationDescription annotationDescription : fieldDescription.getAnnotationDescriptions()) {
                    AnnotationTokenStream tokenStream = this.annotationTokenStreamBuilder.createAnnotationTokenStream(jCas, annotationDescription);
                    if (this.tokenizer.needsTokenization(annotationDescription)) {
                        tokenStream = this.tokenizer.tokenize(tokenStream, annotationDescription);
                    }
                    tokenStream = this.filterBuilder.filter(tokenStream, annotationDescription.getFilterDescriptions());
                    tokenStreams.add(tokenStream);
                }
                fields.addAll(this.fieldBuilder.createFields(tokenStreams, fieldDescription));
            }
            Document document = this.documentBuilder.createDocument(fields);
            return document;
        }
        catch (AnnotationTokenStreamBuildingException e) {
            log.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (FieldBuildingException e) {
            log.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (FilterBuildingException e) {
            log.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (CASException e) {
            log.error((Object)"processCas(CAS)", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    FilterBuilder getFilterBuilder() {
        return this.filterBuilder;
    }

    Collection<FieldDescription> getFieldDescriptions() {
        return this.fieldDescriptions;
    }
}

