/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe.support;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.tools.cfe.support.DictionaryMatcher;
import org.apache.uima.tools.cfe.support.FileBasedDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFileBasedDictionary<T>
extends FileBasedDictionary<T>
implements DictionaryMatcher<String> {
    private Map<String, T> m_storage;
    public final String m_cmtsep;
    public final String m_fldsep;

    public SimpleFileBasedDictionary(String name, String path, Map<String, T> storage, String comment_separator, String filed_separator) {
        super(name, path);
        this.m_cmtsep = comment_separator;
        this.m_fldsep = filed_separator;
        this.m_storage = storage;
        if (null == this.m_storage) {
            this.m_storage = new HashMap<String, T>();
        }
    }

    @Override
    public void load() throws IOException {
        BufferedReader bufReader = new BufferedReader(new FileReader(this.m_path));
        String line = null;
        int cnt = 0;
        while ((line = bufReader.readLine()) != null) {
            String[] columns;
            String[] stringArray;
            ++cnt;
            line = line.trim();
            if (null != this.m_cmtsep && line.startsWith(this.m_cmtsep) || 0 == line.length()) continue;
            if (null == this.m_fldsep) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = line;
            } else {
                stringArray = columns = line.split(this.m_fldsep);
            }
            if (0 == columns.length) continue;
            this.addLine(columns, cnt);
        }
        bufReader.close();
    }

    @Override
    public void save() throws IOException {
        PrintStream ps = new PrintStream(new FileOutputStream(this.path(), false));
        Iterator<String> it = this.m_storage.keySet().iterator();
        while (it.hasNext()) {
            ps.println(this.make_line(it.next()));
        }
        ps.close();
    }

    @Override
    protected void addEntry(String key, T value, int linenum) {
        this.m_storage.put(key, value);
    }

    public Map<String, T> storage() {
        return this.m_storage;
    }

    @Override
    public T getEntry(String key) {
        return this.m_storage.get(key);
    }

    @Override
    public int size() {
        return this.m_storage.size();
    }

    @Override
    public boolean matches(String key) {
        return this.m_storage.containsKey(key);
    }

    private String make_line(String key) {
        if (null == this.m_fldsep) {
            return key.toString();
        }
        return key + this.m_fldsep + this.getEntry(key);
    }
}

