/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe.support;

public class ComparableArray
implements Comparable {
    public final Comparable[] m_src;

    public ComparableArray(Comparable[] src) {
        this.m_src = src;
    }

    private int compare(Comparable[] ia1, Comparable[] ia2) {
        if (ia1 == ia2) {
            return 0;
        }
        if (null == ia1 || null == ia2) {
            return null == ia2 ? 1 : -1;
        }
        if (ia1.length != ia2.length) {
            return ia1.length > ia2.length ? 1 : -1;
        }
        for (int i = 0; i < ia1.length; ++i) {
            int res = ia1[i].compareTo(ia2[i]);
            if (0 == res) continue;
            return res;
        }
        return 0;
    }

    public int compareTo(Object other) {
        if (null == other) {
            return 1;
        }
        if (other instanceof ComparableArray) {
            return this.compare(this.m_src, ((ComparableArray)other).m_src);
        }
        throw new ClassCastException("Cannot compare ComparableArray to object of type " + other.getClass().getName());
    }

    public boolean equals(Object other) {
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        int result = 0;
        result += Math.min(this.m_src.length, 9) * this.m_src.length;
        for (int i = 0; i < this.m_src.length; ++i) {
            result += Math.min(this.m_src.length, 9) * this.m_src[i].hashCode();
        }
        return result;
    }

    public String toString() {
        assert (null != this.m_src);
        StringBuilder result = new StringBuilder(this.m_src.length * 8);
        result.append("[");
        for (int i = 0; i < this.m_src.length; ++i) {
            if (0 != i) {
                result.append(",");
            }
            result.append(this.m_src[i]);
        }
        result.append("]");
        return result.toString();
    }
}

