/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.tools.cfe.CommonFeatureMatcher;
import org.apache.uima.tools.cfe.UIMAFeatureMatcher;
import org.apache.uima.tools.cfe.support.ComparableArray;

public class UIMAFeatureConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIRECTORY = "OutputDirectory";
    private String m_outdir;
    private UIMAFeatureMatcher m_uimaFM;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        try {
            this.m_uimaFM = new UIMAFeatureMatcher((Boolean)this.getConfigParameterValue("IncludeTargetId"));
            String cfgFile = (String)this.getConfigParameterValue("ConfigurationFile");
            if (null != cfgFile) {
                Boolean isXMLBeansarser = (Boolean)this.getConfigParameterValue("XMLBeansParser");
                this.m_uimaFM.initialize(cfgFile, null == isXMLBeansarser ? false : isXMLBeansarser);
            }
            this.m_outdir = (String)this.getConfigParameterValue(PARAM_OUTPUTDIRECTORY);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            String docId = CommonFeatureMatcher.getDocumentId(jcas, null);
            System.out.println("Processing " + docId);
            this.m_uimaFM.processJCas(jcas);
            if (this.m_uimaFM.m_featureImages.isEmpty()) {
                return;
            }
            File f = new File(this.m_outdir);
            if (!f.exists()) {
                System.err.println("Directory " + this.m_outdir + " does not exist, creating");
                if (!f.mkdirs()) {
                    throw new IOException(String.format("failed to create an output directory \"%s\"", this.m_outdir));
                }
            }
            FileOutputStream fos = new FileOutputStream(this.m_outdir + "/" + docId + ".fve");
            Iterator<ComparableArray> it = this.m_uimaFM.m_featureImages.keySet().iterator();
            while (it.hasNext()) {
                fos.write((this.m_uimaFM.m_featureImages.get(it.next()) + "\n").getBytes());
            }
            fos.close();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }
}

