/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.tools.cfe.MatchedSingleFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.SingleFeatureMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupFeatureMatcher {
    Collection<SingleFeatureMatcher> m_single_feature_matchers = new ArrayList<SingleFeatureMatcher>();
    boolean m_exclude;

    public GroupFeatureMatcher(Collection<SingleFeatureMatcher> sfms, boolean exclude) {
        this.m_exclude = exclude;
        this.m_single_feature_matchers.addAll(sfms);
    }

    public void addMatcher(String feat_class, String feat_path, boolean exclude, boolean quiet, String path, boolean case_sensitive) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException {
        this.m_single_feature_matchers.add(new SingleFeatureMatcher(feat_class, feat_path, exclude, quiet, path, case_sensitive));
    }

    public void addMatcher(String feat_class, String feat_path, boolean exclude, boolean quiet, Collection<String> values, boolean case_sensitive) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException {
        this.m_single_feature_matchers.add(new SingleFeatureMatcher(feat_class, feat_path, exclude, quiet, values, case_sensitive));
    }

    public void addMatcher(String feat_class, String feat_path, boolean exclude, boolean quiet, double lb, boolean lbi, double ub, boolean ubi) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException {
        this.m_single_feature_matchers.add(new SingleFeatureMatcher(feat_class, feat_path, exclude, quiet, lb, lbi, ub, ubi));
    }

    public void addMatcher(String feat_class, String feat_path, boolean exclude, boolean quiet, int bitmask, boolean excact_match) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException {
        this.m_single_feature_matchers.add(new SingleFeatureMatcher(feat_class, feat_path, exclude, quiet, bitmask, excact_match));
    }

    public boolean matches(MatchedValue mv, Collection<MatchedSingleFeatureMatcher> matched) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (SingleFeatureMatcher sfm : this.m_single_feature_matchers) {
            ArrayList<MatchedValue> matchedValues;
            if (!sfm.matches(mv, matchedValues = new ArrayList<MatchedValue>())) {
                return this.m_exclude;
            }
            matched.add(new MatchedSingleFeatureMatcher(sfm, matchedValues));
        }
        return !this.m_exclude;
    }

    void update(Object source) throws IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        Iterator<SingleFeatureMatcher> it = this.m_single_feature_matchers.iterator();
        while (it.hasNext()) {
            it.next().update(source);
        }
    }
}

