/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.uima.tools.cfe.CollectionFeatureValues;
import org.apache.uima.tools.cfe.FeatureValueConverter;
import org.apache.uima.tools.cfe.FeatureValueNormalizer;
import org.apache.uima.tools.cfe.PrimitiveFeatureTransformer;
import org.apache.uima.tools.cfe.support.EnumeratedEntryDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFeatureValues
extends CollectionFeatureValues<String> {
    public final PrimitiveFeatureTransformer m_value_transformer;

    public EnumFeatureValues(Collection<String> values, boolean case_sensitive) {
        this((String[])values.toArray((T[])null), case_sensitive);
    }

    public EnumFeatureValues(Object[] values, boolean case_sensitive) {
        super(new HashSet());
        this.m_value_transformer = new PrimitiveFeatureTransformer(case_sensitive);
        if (null != values) {
            for (int i = 0; i < values.length; ++i) {
                this.m_values.add(this.getValueNormalizer().normalize(values[i].toString()));
            }
        }
    }

    public EnumFeatureValues(String path, boolean case_sensitive) throws IOException {
        super(null);
        this.m_value_transformer = new PrimitiveFeatureTransformer(case_sensitive);
        EnumeratedEntryDictionary fd = new EnumeratedEntryDictionary("enum feature values", path, this.getValueNormalizer());
        fd.load();
        this.m_values = fd.values();
    }

    public EnumFeatureValues() {
        this((Object[])null, false);
    }

    public FeatureValueNormalizer getValueNormalizer() {
        return this.m_value_transformer;
    }

    public FeatureValueConverter getValueConverter() {
        return this.m_value_transformer;
    }

    @Override
    public String getFeatureImage(Object feature) {
        return this.m_value_transformer.getValue(feature);
    }

    @Override
    public boolean matches(Object feature) {
        if (this.m_values.isEmpty()) {
            return true;
        }
        return this.m_values.contains(this.getFeatureImage(feature));
    }
}

