/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.AnnotationMatchedValue;
import org.apache.uima.tools.cfe.CFEConfigFromXML_Ecore;
import org.apache.uima.tools.cfe.CFEConfigFromXML_XMLBeans;
import org.apache.uima.tools.cfe.FeatureObjectMatcher;
import org.apache.uima.tools.cfe.MatchedAnnotationDescriptor;
import org.apache.uima.tools.cfe.MatchedSingleFeatureMatcher;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.ObjectPathFeatureValues;
import org.apache.uima.tools.cfe.PartialObjectMatcher;
import org.apache.uima.tools.cfe.PrimitiveFeatureTransformer;
import org.apache.uima.tools.cfe.TargetAnnotationDescriptor;
import org.apache.uima.tools.cfe.TargetObjectMatcher;
import org.apache.uima.tools.cfe.support.FeatureConstrainedIterator;
import org.apache.uima.tools.cfe.support.UIMAAnnotationUtils;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonFeatureMatcher {
    private Map<AnnotationMatchedValue, Map<String, Collection<MatchedAnnotationDescriptor>>> m_feature_annotations;
    private Collection<TargetAnnotationDescriptor> m_TADescriptors;
    public final boolean m_isAnnotationName;
    public final boolean m_isFeatureName;
    public final boolean m_isTargetId;
    public final String m_fieldSeparator;
    public final String[] m_valueSeparators;
    public static final String PARAM_CONFIGURATIONFILE = "ConfigurationFile";
    public static final String PARAM_INCLUDETARGETID = "IncludeTargetId";
    public static final String PARAM_INCLUDEANNOTATIONNAME = "IncludeAnnotationName";
    public static final String PARAM_INCLUDEFEATURENAME = "IncludeFeatureName";
    public static final String PARAM_XMLBEANSPARSER = "XMLBeansParser";
    public static final int CONSTANT_INGORE = 0;
    public static final int CONSTANT_LEFTLEFT = 1;
    public static final int CONSTANT_LEFTINSIDE = 2;
    public static final int CONSTANT_LEFTRIGHT = 4;
    public static final int CONSTANT_INSIDEINSIDE = 8;
    public static final int CONSTANT_INSIDERIGHT = 16;
    public static final int CONSTANT_RIGHTRIGHT = 32;
    public static final int CONSTANT_STARTSLEFT = 7;
    public static final int CONSTANT_STARTSINSIDE = 24;
    public static final int CONSTANT_STARTSRIGHT = 32;
    public static final int CONSTANT_ANYENCLOSED = 63;
    private static Pattern m_featname_pattern = Pattern.compile("\\{([^\\}\\s]+)\\}");

    protected abstract void processFeatureGroup(JCas var1, Annotation var2, String var3, Collection<MatchedAnnotationDescriptor> var4) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    CommonFeatureMatcher(boolean isTargetId, boolean isAnnotationName, boolean isFeatureName, String fieldSeparator, String[] valueSeparators) {
        this.m_isTargetId = isTargetId;
        this.m_isAnnotationName = isAnnotationName;
        this.m_isFeatureName = isFeatureName;
        this.m_fieldSeparator = fieldSeparator;
        this.m_valueSeparators = valueSeparators;
    }

    public void initialize(String configfile, boolean isXMLBeansParser) throws SecurityException, ClassNotFoundException, NoSuchMethodException, URISyntaxException, IOException, XmlException {
        if (isXMLBeansParser) {
            this.parseConfigFile_XMLBeans(configfile);
        } else {
            this.parseConfigFile_Ecore(configfile);
        }
    }

    void parseConfigFile_Ecore(String path) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, URISyntaxException {
        CFEConfigFromXML_Ecore xml2CFE = new CFEConfigFromXML_Ecore(path);
        if (null != xml2CFE.getNullValueImage()) {
            PrimitiveFeatureTransformer.nullValueImage = xml2CFE.getNullValueImage();
        }
        this.m_TADescriptors = xml2CFE.getTargetAnnotationDescriptors();
    }

    void parseConfigFile_XMLBeans(String path) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, URISyntaxException, XmlException {
        CFEConfigFromXML_XMLBeans xml2CFE = new CFEConfigFromXML_XMLBeans(path);
        if (null != xml2CFE.getNullValueImage()) {
            PrimitiveFeatureTransformer.nullValueImage = xml2CFE.getNullValueImage();
        }
        this.m_TADescriptors = xml2CFE.getTargetAnnotationDescriptors();
    }

    void processSelectedFeatureAnnotation(JCas jcas) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (AnnotationMatchedValue trg_mv : this.m_feature_annotations.keySet()) {
            Map<String, Collection<MatchedAnnotationDescriptor>> target_feature_groups = this.m_feature_annotations.get(trg_mv);
            for (Map.Entry<String, Collection<MatchedAnnotationDescriptor>> entry : target_feature_groups.entrySet()) {
                String class_label = entry.getKey();
                Collection<MatchedAnnotationDescriptor> features = entry.getValue();
                this.processFeatureGroup(jcas, trg_mv.getAnnotation(), class_label, features);
            }
        }
    }

    protected static String make_image_position(MatchedAnnotationDescriptor mad) {
        StringBuilder strBuf = new StringBuilder();
        if (mad.m_feature_matcher.m_orientation) {
            strBuf.append(1 == mad.m_direction ? "L" : (2 == mad.m_direction ? "LI" : (4 == mad.m_direction ? "LR" : (8 == mad.m_direction ? "I" : (16 == mad.m_direction ? "IR" : (32 == mad.m_direction ? "R" : "X"))))));
        }
        if (mad.m_feature_matcher.m_distance) {
            strBuf.append(mad.m_offset);
        }
        return strBuf.toString();
    }

    protected String make_image(MatchedAnnotationDescriptor mad, Annotation trg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        StringBuilder sb = new StringBuilder(mad.m_sfms_with_values.size() * 20);
        if (this.m_isAnnotationName) {
            String[] name_toks = mad.m_feature_mv.m_matchedObject.getClass().getName().split("\\.");
            sb.append(name_toks[name_toks.length - 1]);
        }
        for (MatchedSingleFeatureMatcher sfm_values : mad.m_sfms_with_values) {
            if (sfm_values.m_matcher.m_quiet) continue;
            if (0 != sb.length()) {
                sb.append(this.m_fieldSeparator);
            }
            sb.append(sfm_values.getFeatureImage(this.m_isFeatureName, this.m_valueSeparators));
        }
        if (this.m_isTargetId) {
            sb.append(this.m_fieldSeparator);
            sb.append(trg.getAddress());
        }
        return sb.toString();
    }

    String parseClassLabel(String class_label, MatchedValue trg_mv) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Matcher m = m_featname_pattern.matcher(class_label);
        StringBuilder result = new StringBuilder();
        int class_label_ind = 0;
        while (m.find()) {
            String featname = m.group(1);
            int begin = m.start(1);
            int end = m.end(1);
            if (begin - 1 > class_label_ind) {
                result.append(class_label.substring(class_label_ind, begin - 1));
            }
            class_label_ind = end + 1;
            TargetObjectMatcher tom = new TargetObjectMatcher((Class<? extends Object>)null, trg_mv.m_matchedObject.getClass().getName() + ":" + featname, false);
            List<MatchedValue> vals = tom.getFeatureValues(trg_mv);
            StringBuilder feat_image = new StringBuilder();
            Iterator<MatchedValue> it = vals.iterator();
            while (it.hasNext()) {
                feat_image.append(it.next().m_matchedObject);
                if (!it.hasNext()) continue;
                feat_image.append(this.m_fieldSeparator);
            }
            result.append((CharSequence)feat_image);
        }
        result.append(class_label.substring(class_label_ind));
        return result.toString();
    }

    void collectFeatures(JCas jcas, TargetAnnotationDescriptor tad, AnnotationMatchedValue trg_mv, MatchedAnnotationDescriptor feat_ann_mad) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Map<Object, Object> target_feature_groups = null;
        if (this.m_feature_annotations.containsKey(trg_mv)) {
            target_feature_groups = this.m_feature_annotations.get(trg_mv);
        } else {
            target_feature_groups = new HashMap();
            this.m_feature_annotations.put(trg_mv, target_feature_groups);
        }
        Collection<MatchedAnnotationDescriptor> features = null;
        String class_label = this.parseClassLabel(tad.getClassName(), trg_mv);
        if (target_feature_groups.containsKey(class_label)) {
            features = (Collection)target_feature_groups.get(class_label);
        } else {
            features = new ArrayList();
            target_feature_groups.put(class_label, features);
        }
        features.add(feat_ann_mad);
    }

    public static String getDocumentId(JCas jcas, Annotation doc_ann) {
        String doc_id = null;
        try {
            Iterator<SourceDocumentInformation> it = UIMAAnnotationUtils.iterator(jcas, SourceDocumentInformation.class);
            while (it.hasNext() && null == doc_id) {
                SourceDocumentInformation sdi = it.next();
                String[] toks = sdi.getUri().split("\\/");
                doc_id = toks[toks.length - 1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null == doc_id ? "" : doc_id;
    }

    boolean processFeatureAnnotation(JCas jcas, Annotation enclosing, AnnotationMatchedValue trg_mv, AnnotationMatchedValue feat_mv, TargetAnnotationDescriptor tad, FeatureObjectMatcher fom, int direction, int offset) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        ArrayList<MatchedSingleFeatureMatcher> ann_matched_features = new ArrayList<MatchedSingleFeatureMatcher>();
        if (fom.matches(feat_mv, ann_matched_features)) {
            MatchedAnnotationDescriptor mad = new MatchedAnnotationDescriptor(fom, enclosing, feat_mv, ann_matched_features, direction, offset, tad.m_priorityOrder);
            this.collectFeatures(jcas, tad, trg_mv, mad);
            return true;
        }
        return false;
    }

    private int orientationFlags(Annotation ann, Annotation trg) {
        int result = 0;
        if (ann.getEnd() < trg.getBegin() && ann.getEnd() < trg.getBegin()) {
            result = 1;
        } else if (ann.getBegin() < trg.getBegin() && ann.getEnd() <= trg.getEnd()) {
            result = 2;
        } else if (ann.getBegin() < trg.getBegin() && ann.getEnd() > trg.getEnd()) {
            result = 4;
        } else if (ann.getBegin() <= trg.getEnd() && ann.getEnd() <= trg.getEnd()) {
            result = 8;
        } else if (ann.getBegin() <= trg.getEnd() && ann.getEnd() > trg.getEnd()) {
            result = 16;
        } else if (ann.getBegin() > trg.getEnd() && ann.getEnd() > trg.getEnd()) {
            result = 32;
        }
        return result;
    }

    void processFeatureAnnotationWindow(JCas jcas, Annotation enclosing, AnnotationMatchedValue trg_mv, TargetAnnotationDescriptor tad, FeatureObjectMatcher fom, Collection<AnnotationMatchedValue> allowedAnnotations, int begin_lower, int begin_upper, int end_lower, int end_upper, int windowsize, boolean advance_right) throws IllegalArgumentException, SecurityException, NoSuchElementException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        Class<? extends Annotation> ann_cls = UIMAAnnotationUtils.getAnnotationClass(fom.getMatcherClass());
        FSIterator<? extends Annotation> ann_it = FeatureConstrainedIterator.getEnclosedIterator(jcas, ann_cls, begin_lower, begin_upper, end_lower, end_upper);
        if (!advance_right) {
            ann_it.moveToLast();
        }
        Annotation trg = (Annotation)trg_mv.m_matchedObject;
        int wc = 1;
        while (ann_it.isValid() && wc <= windowsize) {
            Annotation ann = (Annotation)ann_it.get();
            AnnotationMatchedValue feat_mv = MatchedValue.get(allowedAnnotations, ann);
            if (null == feat_mv) continue;
            if (this.processFeatureAnnotation(jcas, enclosing, trg_mv, feat_mv, tad, fom, this.orientationFlags(ann, trg), wc)) {
                ++wc;
            }
            if (advance_right) {
                ann_it.moveToNext();
                continue;
            }
            ann_it.moveToPrevious();
        }
    }

    void processFeatureAnnotationWindow(JCas jcas, Annotation enclosing, AnnotationMatchedValue trg_mv, TargetAnnotationDescriptor tad, FeatureObjectMatcher fom, Collection<AnnotationMatchedValue> allowedAnnotations, int windowflags, int windowsize, boolean advance_right) throws IllegalArgumentException, SecurityException, NoSuchElementException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        int bl = Integer.MAX_VALUE;
        int bu = -2147483647;
        int el = Integer.MAX_VALUE;
        int eu = -2147483647;
        if (63 == (windowflags & 0x3F)) {
            bl = bu = enclosing.getBegin();
            el = eu = enclosing.getEnd();
        } else {
            Annotation trg = (Annotation)trg_mv.m_matchedObject;
            if (0 != (windowflags & 1)) {
                bl = Math.min(bl, enclosing.getBegin());
                bu = Math.max(bu, trg.getBegin());
                el = Math.min(el, enclosing.getBegin());
                eu = Math.max(eu, trg.getBegin());
            }
            if (0 != (windowflags & 2)) {
                bl = Math.min(bl, enclosing.getBegin());
                bu = Math.max(bu, trg.getBegin());
                el = Math.min(el, trg.getBegin());
                eu = Math.max(eu, trg.getEnd());
            }
            if (0 != (windowflags & 4)) {
                bl = Math.min(bl, enclosing.getBegin());
                bu = Math.max(bu, trg.getBegin());
                el = Math.min(el, trg.getEnd());
                eu = Math.max(eu, enclosing.getEnd());
            }
            if (0 != (windowflags & 8)) {
                bl = Math.min(bl, trg.getBegin());
                bu = Math.max(bu, trg.getEnd());
                el = Math.min(el, trg.getBegin());
                eu = Math.max(eu, trg.getEnd());
            }
            if (0 != (windowflags & 0x10)) {
                bl = Math.min(bl, trg.getBegin());
                bu = Math.max(bu, trg.getEnd());
                el = Math.min(el, trg.getEnd());
                eu = Math.max(eu, enclosing.getEnd());
            }
            if (0 != (windowflags & 0x20)) {
                bl = Math.min(bl, trg.getEnd());
                bu = Math.max(bu, enclosing.getEnd());
                el = Math.min(el, trg.getEnd());
                eu = Math.max(eu, enclosing.getEnd());
            }
            if (Integer.MAX_VALUE == bl) {
                throw new IllegalArgumentException("Invalid windowflags: " + windowflags);
            }
            if (bl == el && bu == eu) {
                bu = bl;
                el = eu;
            }
        }
        this.processFeatureAnnotationWindow(jcas, enclosing, trg_mv, tad, fom, allowedAnnotations, bl, bu, el, eu, windowsize, advance_right);
    }

    private Map<PartialObjectMatcher, Collection<AnnotationMatchedValue>> createAllowedAnnotationsMap(JCas jcas, Collection<? extends PartialObjectMatcher> poms, Annotation enclosing) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        HashMap<PartialObjectMatcher, Collection<AnnotationMatchedValue>> per_model_matched = new HashMap<PartialObjectMatcher, Collection<AnnotationMatchedValue>>();
        HashSet<MatchedValue> all_models_matched = new HashSet<MatchedValue>();
        for (PartialObjectMatcher partialObjectMatcher : poms) {
            if (per_model_matched.keySet().contains(partialObjectMatcher)) continue;
            ObjectPathFeatureValues opvfs = new ObjectPathFeatureValues(partialObjectMatcher.getMatcherClass().getName(), partialObjectMatcher.getObjectPath());
            opvfs.update(jcas, enclosing, all_models_matched);
            if (opvfs.m_values.isEmpty()) continue;
            ArrayList<AnnotationMatchedValue> amvs = new ArrayList<AnnotationMatchedValue>();
            per_model_matched.put(partialObjectMatcher, AnnotationMatchedValue.upcast(amvs, opvfs.m_values));
        }
        return per_model_matched;
    }

    void processMatchedTargetAnnotation(JCas jcas, Annotation enclosing, AnnotationMatchedValue trg_mv, TargetAnnotationDescriptor tad) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchElementException, ClassNotFoundException, NoSuchFieldException {
        Map<PartialObjectMatcher, Collection<AnnotationMatchedValue>> allowedAnnotationsMap = this.createAllowedAnnotationsMap(jcas, tad.getFeatureAnnotationMatchers(), enclosing);
        for (FeatureObjectMatcher fom : tad.getFeatureAnnotationMatchers()) {
            int mask;
            Collection<AnnotationMatchedValue> allowedAnnotations = allowedAnnotationsMap.get(fom);
            if (fom.m_windowsizeLeft > 0) {
                mask = fom.m_windowFlags & 7;
                this.processFeatureAnnotationWindow(jcas, enclosing, trg_mv, tad, fom, allowedAnnotations, 0 == mask ? 1 : mask, fom.m_windowsizeLeft, false);
            }
            if (1 == fom.m_windowsizeInside && tad.getTargetAnnotationMatcher().getMatcherClass().equals(fom.getMatcherClass())) {
                this.processFeatureAnnotation(jcas, enclosing, trg_mv, trg_mv, tad, fom, 8, 1);
            } else if (fom.m_windowsizeInside > 0) {
                mask = fom.m_windowFlags & 0x18;
                this.processFeatureAnnotationWindow(jcas, enclosing, trg_mv, tad, fom, allowedAnnotations, 0 == mask ? 8 : mask, fom.m_windowsizeInside, true);
            }
            if (fom.m_windowsizeRight > 0) {
                mask = fom.m_windowFlags & 0x20;
                this.processFeatureAnnotationWindow(jcas, enclosing, trg_mv, tad, fom, allowedAnnotations, 0 == mask ? 32 : mask, fom.m_windowsizeRight, true);
            }
            if (fom.m_windowsizeEnclosed <= 0) continue;
            this.processFeatureAnnotationWindow(jcas, enclosing, trg_mv, tad, fom, allowedAnnotations, 63, fom.m_windowsizeEnclosed, true);
        }
    }

    void processEnclosingAnnotation(JCas jcas, Annotation enclosing, Collection<AnnotationMatchedValue> targetAnnotations, TargetAnnotationDescriptor tad) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchElementException, ClassNotFoundException, NoSuchFieldException {
        PartialObjectMatcher targetAnnotationMatcher = tad.getTargetAnnotationMatcher();
        Class<? extends Annotation> trg_cls = UIMAAnnotationUtils.getAnnotationClass(targetAnnotationMatcher.getMatcherClass());
        FSIterator<? extends Annotation> it = FeatureConstrainedIterator.getEnclosedIterator(jcas, trg_cls, enclosing.getBegin(), enclosing.getEnd());
        while (it.hasNext()) {
            ArrayList<MatchedSingleFeatureMatcher> trg_matched_features;
            Annotation trg = (Annotation)it.next();
            AnnotationMatchedValue trg_mv = MatchedValue.get(targetAnnotations, trg);
            if (null == trg_mv || !targetAnnotationMatcher.matches(trg_mv, trg_matched_features = new ArrayList<MatchedSingleFeatureMatcher>())) continue;
            this.processMatchedTargetAnnotation(jcas, enclosing, trg_mv, tad);
        }
    }

    public void processJCas(JCas jcas) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        this.m_feature_annotations = new HashMap<AnnotationMatchedValue, Map<String, Collection<MatchedAnnotationDescriptor>>>();
        ArrayList<PartialObjectMatcher> tams = new ArrayList<PartialObjectMatcher>();
        for (TargetAnnotationDescriptor tad : this.m_TADescriptors) {
            PartialObjectMatcher pom = tad.getTargetAnnotationMatcher();
            tams.add(pom);
            pom.update(jcas);
        }
        Map<PartialObjectMatcher, Collection<AnnotationMatchedValue>> allowedAnnotationsMap = this.createAllowedAnnotationsMap(jcas, tams, null);
        for (TargetAnnotationDescriptor tad : this.m_TADescriptors) {
            if (!allowedAnnotationsMap.containsKey(tad.getTargetAnnotationMatcher())) continue;
            Collection<AnnotationMatchedValue> allowedAnnotations = allowedAnnotationsMap.get(tad.getTargetAnnotationMatcher());
            Class<? extends Annotation> cls = UIMAAnnotationUtils.forName(tad.getEnclosingAnnotationName());
            Iterator<? extends Annotation> eg_it = UIMAAnnotationUtils.iterator(jcas, cls);
            while (eg_it.hasNext()) {
                this.processEnclosingAnnotation(jcas, eg_it.next(), allowedAnnotations, tad);
            }
        }
        this.processSelectedFeatureAnnotation(jcas);
    }
}

