/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.tools.cfe.BitsetFeatureValues;
import org.apache.uima.tools.cfe.EnumFeatureValues;
import org.apache.uima.tools.cfe.FeatureObjectMatcher;
import org.apache.uima.tools.cfe.GroupFeatureMatcher;
import org.apache.uima.tools.cfe.ObjectPathFeatureValues;
import org.apache.uima.tools.cfe.PartialObjectMatcher;
import org.apache.uima.tools.cfe.PatternFeatureValues;
import org.apache.uima.tools.cfe.RangeFeatureValues;
import org.apache.uima.tools.cfe.SingleFeatureMatcher;
import org.apache.uima.tools.cfe.TargetAnnotationDescriptor;
import org.apache.uima.tools.cfe.config.xmlBeans.BitsetFeatureValuesXML;
import org.apache.uima.tools.cfe.config.xmlBeans.CFEConfigDocument;
import org.apache.uima.tools.cfe.config.xmlBeans.CFEDescriptorXML;
import org.apache.uima.tools.cfe.config.xmlBeans.EnumFeatureValuesXML;
import org.apache.uima.tools.cfe.config.xmlBeans.FeatureObjectMatcherXML;
import org.apache.uima.tools.cfe.config.xmlBeans.GroupFeatureMatcherXML;
import org.apache.uima.tools.cfe.config.xmlBeans.ObjectPathFeatureValuesXML;
import org.apache.uima.tools.cfe.config.xmlBeans.PartialObjectMatcherXML;
import org.apache.uima.tools.cfe.config.xmlBeans.PatternFeatureValuesXML;
import org.apache.uima.tools.cfe.config.xmlBeans.RangeFeatureValuesXML;
import org.apache.uima.tools.cfe.config.xmlBeans.SingleFeatureMatcherXML;
import org.apache.uima.tools.cfe.config.xmlBeans.TargetAnnotationXML;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFEConfigFromXML_XMLBeans {
    private final CFEDescriptorXML m_CFEDescriptor;

    public CFEConfigFromXML_XMLBeans(String path) throws XmlException, IOException {
        CFEConfigDocument doc = CFEConfigDocument.Factory.parse(new File(path));
        this.m_CFEDescriptor = doc.getCFEConfig();
    }

    EnumFeatureValues getEnumFeatureValues(EnumFeatureValuesXML efvs_xml) throws IOException, URISyntaxException {
        List<String> vals = efvs_xml.getValuesList();
        if (1 == vals.size() && vals.get(0).startsWith("file://")) {
            return new EnumFeatureValues(CFEConfigFromXML_XMLBeans.quote(vals.get(0)).getPath(), efvs_xml.getCaseSensitive());
        }
        return new EnumFeatureValues(vals, efvs_xml.getCaseSensitive());
    }

    RangeFeatureValues getRangeFeatureValues(RangeFeatureValuesXML rfvs_xml) {
        String lb = rfvs_xml.getLowerBoundary().toString().trim();
        String ub = rfvs_xml.getUpperBoundary().toString().trim();
        return new RangeFeatureValues(Double.parseDouble(lb), rfvs_xml.getLowerBoundaryInclusive(), Double.parseDouble(ub), rfvs_xml.getUpperBoundaryInclusive());
    }

    BitsetFeatureValues getBitsetFeatureValues(BitsetFeatureValuesXML bfvs_xml) {
        return new BitsetFeatureValues(Integer.parseInt(bfvs_xml.getBitmask(), 16), bfvs_xml.getExactMatch());
    }

    PatternFeatureValues getPatternFeatureValues(PatternFeatureValuesXML pattern_xml) {
        return new PatternFeatureValues(pattern_xml.getPattern());
    }

    ObjectPathFeatureValues getObjectPathFeatureValues(ObjectPathFeatureValuesXML opfvs_xml, String feature_class) {
        return new ObjectPathFeatureValues(feature_class, opfvs_xml.getObjectPath());
    }

    SingleFeatureMatcher getSingleFeatureMatcher(SingleFeatureMatcherXML sfm_xml, String obj_class) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException, URISyntaxException {
        if (null != sfm_xml.getEnumFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), this.getEnumFeatureValues(sfm_xml.getEnumFeatureValues()));
        }
        if (null != sfm_xml.getRangeFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), this.getRangeFeatureValues(sfm_xml.getRangeFeatureValues()));
        }
        if (null != sfm_xml.getBitsetFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), this.getBitsetFeatureValues(sfm_xml.getBitsetFeatureValues()));
        }
        if (null != sfm_xml.getPatternFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), this.getPatternFeatureValues(sfm_xml.getPatternFeatureValues()));
        }
        if (null != sfm_xml.getObjectPathFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), this.getObjectPathFeatureValues(sfm_xml.getObjectPathFeatureValues(), sfm_xml.getFeatureTypeName()));
        }
        return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.getExclude(), sfm_xml.getQuiet(), new EnumFeatureValues());
    }

    GroupFeatureMatcher getGroupFeatureMatcher(GroupFeatureMatcherXML gfm_xml, String obj_class_name) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException, URISyntaxException {
        List<SingleFeatureMatcherXML> fms_xml = gfm_xml.getFeatureMatchersList();
        ArrayList<SingleFeatureMatcher> sfms = new ArrayList<SingleFeatureMatcher>();
        for (SingleFeatureMatcherXML fm_xml : fms_xml) {
            sfms.add(this.getSingleFeatureMatcher(fm_xml, obj_class_name));
        }
        return new GroupFeatureMatcher(sfms, gfm_xml.getExclude());
    }

    PartialObjectMatcher getPartialObjectMatcher(PartialObjectMatcherXML pom_xml) throws SecurityException, NoSuchMethodException, IOException, URISyntaxException, ClassNotFoundException {
        List<GroupFeatureMatcherXML> gfms_xml = pom_xml.getGroupFeatureMatchersList();
        ArrayList<GroupFeatureMatcher> gfms = new ArrayList<GroupFeatureMatcher>();
        for (GroupFeatureMatcherXML gfm_xml : gfms_xml) {
            gfms.add(this.getGroupFeatureMatcher(gfm_xml, pom_xml.getAnnotationTypeName()));
        }
        return new PartialObjectMatcher(pom_xml.getAnnotationTypeName(), pom_xml.getFullPath(), gfms);
    }

    FeatureObjectMatcher getFeatureObjectMatcher(FeatureObjectMatcherXML fom_xml) throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        List<GroupFeatureMatcherXML> gfms_xml = fom_xml.getGroupFeatureMatchersList();
        ArrayList<GroupFeatureMatcher> gfms = new ArrayList<GroupFeatureMatcher>();
        for (GroupFeatureMatcherXML gfm_xml : gfms_xml) {
            gfms.add(this.getGroupFeatureMatcher(gfm_xml, fom_xml.getAnnotationTypeName()));
        }
        return new FeatureObjectMatcher(fom_xml.getAnnotationTypeName(), fom_xml.getFullPath(), gfms, fom_xml.getWindowsizeLeft(), fom_xml.getWindowsizeInside(), fom_xml.getWindowsizeRight(), fom_xml.getWindowsizeEnclosed(), fom_xml.getWindowFlags(), fom_xml.getOrientation(), fom_xml.getDistance());
    }

    TargetAnnotationDescriptor getTargetAnnotationDescriptor(TargetAnnotationXML ta_xml, int priorityOrder) throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        PartialObjectMatcher ta_matcher = this.getPartialObjectMatcher(ta_xml.getTargetAnnotationMatcher());
        List<FeatureObjectMatcherXML> fams_xml = ta_xml.getFeatureAnnotationMatchersList();
        ArrayList<FeatureObjectMatcher> fams = new ArrayList<FeatureObjectMatcher>();
        for (FeatureObjectMatcherXML fam_xml : fams_xml) {
            fams.add(this.getFeatureObjectMatcher(fam_xml));
        }
        return new TargetAnnotationDescriptor(ta_xml.getClassName(), ta_xml.getEnclosingAnnotation(), ta_matcher, fams, priorityOrder);
    }

    public List<TargetAnnotationDescriptor> getTargetAnnotationDescriptors() throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        ArrayList<TargetAnnotationDescriptor> result = new ArrayList<TargetAnnotationDescriptor>();
        List<TargetAnnotationXML> tans = this.m_CFEDescriptor.getTargetAnnotationsList();
        for (TargetAnnotationXML tan_xml : tans) {
            result.add(this.getTargetAnnotationDescriptor(tan_xml, result.size() + 1));
        }
        return result;
    }

    public String getNullValueImage() {
        return this.m_CFEDescriptor.getNullValueImage();
    }

    private static URI quote(String s) throws URISyntaxException {
        if (-1 == s.indexOf(37)) {
            return new URI(null, s, null);
        }
        return new URI(s);
    }
}

