/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.solrcas;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.solrcas.FieldMappingReader;
import org.apache.uima.solrcas.SolrMappingConfiguration;
import org.apache.uima.solrcas.UriUtils;
import org.apache.uima.util.Level;
import org.xml.sax.SAXException;

public class SolrCASConsumer
extends CasAnnotator_ImplBase {
    private static final String CLASSPATH = "classpath:";
    private static final String FILEPATH = "file://";
    private static final String EMPTY_STRING = "";
    protected SolrServer solrServer;
    private SolrMappingConfiguration mappingConfig;
    private boolean autoCommit;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.solrServer = this.createServer();
        }
        catch (Exception e) {
            context.getLogger().log(Level.SEVERE, "Unable to initialize SolrServer properly");
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.mappingConfig = this.createSolrMappingConfiguration();
        }
        catch (Exception e) {
            context.getLogger().log(Level.SEVERE, "Unable to initialize Solr mapping configuration properly");
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.autoCommit = this.getAutoCommitValue();
        }
        catch (Exception e) {
            context.getLogger().log(Level.SEVERE, "Unable to initialize Solr autoCommit parameter properly");
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        for (String key : this.mappingConfig.getFeatureStructuresMapping().keySet()) {
            Type type = typeSystem.getType(key);
            if (type == null) {
                throw new AnalysisEngineProcessException("required_feature_structure_missing_from_cas", new Object[]{key});
            }
            Map<String, String> stringStringMap = this.mappingConfig.getFeatureStructuresMapping().get(key);
            for (String featureName : stringStringMap.keySet()) {
                if ("coveredText".equals(featureName) || type.getFeatureByBaseName(featureName) != null) continue;
                throw new AnalysisEngineProcessException("required_attribute_missing", new Object[]{featureName, type});
            }
        }
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        SolrInputDocument document = this.createDocument(cas);
        try {
            this.solrServer.add(document);
        }
        catch (Exception e) {
            this.getContext().getLogger().log(Level.SEVERE, "Error while adding document" + document.toString());
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        if (!this.autoCommit) {
            try {
                this.solrServer.commit();
            }
            catch (Exception e) {
                this.getContext().getLogger().log(Level.SEVERE, "Error while committing document" + document.toString());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    protected URI getURI(String path) throws ResourceAccessException, IOException, URISyntaxException {
        URI uri;
        if (path.startsWith(CLASSPATH)) {
            uri = System.class.getResource(path.replaceFirst(CLASSPATH, EMPTY_STRING)).toURI();
        } else {
            uri = UriUtils.create(path);
            if (!uri.isAbsolute()) {
                String dataPath = this.getContext().getDataPath().replace('\\', '/');
                if (dataPath.matches("[a-zA-Z]\\:.*")) {
                    dataPath = "/" + dataPath;
                }
                uri = UriUtils.create(FILEPATH + dataPath + "/" + path.replace(FILEPATH, EMPTY_STRING));
            }
        }
        return uri;
    }

    private boolean getAutoCommitValue() {
        boolean autoCommitValue = false;
        Object autoCommitParam = this.getContext().getConfigParameterValue("autoCommit");
        if (autoCommitParam != null && autoCommitParam.toString().length() > 0) {
            autoCommitValue = Boolean.valueOf(autoCommitParam.toString());
        }
        return autoCommitValue;
    }

    private SolrMappingConfiguration createSolrMappingConfiguration() throws IOException, ResourceAccessException, ParserConfigurationException, SAXException, URISyntaxException {
        FieldMappingReader fieldMappingReader = new FieldMappingReader();
        String mappingFileParam = String.valueOf(this.getContext().getConfigParameterValue("mappingFile"));
        InputStream input = this.getURI(mappingFileParam).toURL().openStream();
        SolrMappingConfiguration solrMappingConfiguration = fieldMappingReader.getConf(input);
        return solrMappingConfiguration;
    }

    protected SolrServer createServer() throws SolrServerException {
        CommonsHttpSolrServer solrServer = null;
        try {
            String solrInstanceTypeParam = String.valueOf(this.getContext().getConfigParameterValue("solrInstanceType"));
            String solrPathParam = String.valueOf(this.getContext().getConfigParameterValue("solrPath"));
            if (solrInstanceTypeParam.equalsIgnoreCase("http")) {
                URL solrURL = UriUtils.create(solrPathParam).toURL();
                solrServer = new CommonsHttpSolrServer(solrURL);
            }
        }
        catch (Exception e) {
            throw new SolrServerException("Error creating SolrServer", (Throwable)e);
        }
        return solrServer;
    }

    private SolrInputDocument createDocument(CAS cas) {
        SolrInputDocument document = new SolrInputDocument();
        if (this.mappingConfig.getDocumentTextMapping() != null && this.mappingConfig.getDocumentTextMapping().length() > 0) {
            document.addField(this.mappingConfig.getDocumentTextMapping(), (Object)cas.getDocumentText());
        }
        if (this.mappingConfig.getDocumentLanguageMapping() != null && this.mappingConfig.getDocumentLanguageMapping().length() > 0) {
            document.addField(this.mappingConfig.getDocumentLanguageMapping(), (Object)cas.getDocumentLanguage());
        }
        for (String key : this.mappingConfig.getFeatureStructuresMapping().keySet()) {
            Type type = cas.getTypeSystem().getType(key);
            FSIterator iterator = cas.getIndexRepository().getAllIndexedFS(type);
            while (iterator.hasNext()) {
                FeatureStructure fs = (FeatureStructure)iterator.next();
                Map<String, String> stringStringMap = this.mappingConfig.getFeatureStructuresMapping().get(key);
                for (String featureName : stringStringMap.keySet()) {
                    String featureValue;
                    String fieldName = stringStringMap.get(featureName);
                    if (fs instanceof AnnotationFS && "coveredText".equals(featureName)) {
                        featureValue = ((AnnotationFS)fs).getCoveredText();
                    } else {
                        Feature feature = type.getFeatureByBaseName(featureName);
                        featureValue = fs.getFeatureValueAsString(feature);
                    }
                    document.addField(fieldName, (Object)featureValue);
                }
            }
        }
        return document;
    }
}

