/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.PearPlugin;
import org.apache.uima.pear.insd.edit.INSDComponentPage;
import org.apache.uima.pear.insd.edit.INSDEnvironmentPage;
import org.apache.uima.pear.insd.edit.InsdConstants;
import org.apache.uima.pear.insd.edit.PearInstallationDescriptor;
import org.apache.uima.pear.insd.edit.vars.VarVal;
import org.apache.uima.pear.nature.ProjectCustomizer;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class EditInstallationDescriptorWizard
extends Wizard
implements IWizard,
InsdConstants {
    private IProject currentProject;
    private InstallationDescriptor insd;
    private Hashtable wizardData = new Hashtable();
    private INSDComponentPage componentPage;
    private INSDEnvironmentPage environmentPage;

    public EditInstallationDescriptorWizard(IProject project) {
        PearException subEx;
        try {
            this.setWindowTitle("Edit PEAR Installation Descriptor");
            this.setDefaultPageImageDescriptor(PearPlugin.getImageDescriptor("editInsdWiz.gif"));
            this.setNeedsProgressMonitor(true);
            this.currentProject = project;
        }
        catch (Throwable e) {
            subEx = new PearException("Operation failed because the wizard could not be initialized.\nPlease report this error.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
        try {
            this.insd = PearInstallationDescriptor.getInstallationDescriptor((IContainer)this.currentProject);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.insd = new InstallationDescriptor();
        }
        try {
            ProjectCustomizer.customizeProject((IContainer)this.currentProject, this.insd);
        }
        catch (Throwable e) {
            subEx = new PearException("Operation failed because the wizard could not customize your project as a UIMA project.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    public void addPages() {
        try {
            this.componentPage = new INSDComponentPage((IContainer)this.currentProject, this.insd, this.wizardData);
            this.addPage((IWizardPage)this.componentPage);
            this.environmentPage = new INSDEnvironmentPage((IContainer)this.currentProject, this.insd, this.wizardData);
            this.addPage((IWizardPage)this.environmentPage);
        }
        catch (Throwable e) {
            PearException subEx = new PearException("Operation failed because the wizard's pages could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    public boolean performFinish() {
        try {
            this.editInstallationDescriptor();
        }
        catch (Throwable e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("An error happened while trying to execute the wizard operetions: \n\nDetails:\n " + e.getMessage()));
        }
        return true;
    }

    private void editInstallationDescriptor() throws CoreException, IOException {
        this.handleComponentInformation();
        this.addEnvOptions();
        this.addEnvVars();
        PearInstallationDescriptor.saveInstallationDescriptor((IContainer)this.currentProject, this.insd);
    }

    private void handleComponentInformation() {
        this.insd.setMainComponent(this.componentPage.compID);
        this.insd.setMainComponentDesc(PearInstallationDescriptor.addMacro(this.componentPage.compDescriptorPath));
    }

    private void addEnvOptions() {
        String jdkVersion;
        this.insd.clearOSSpecs();
        this.insd.clearToolkitsSpecs();
        this.insd.clearFrameworkSpecs();
        String os = this.environmentPage.osCombo.getText();
        if (os != null && os.trim().length() > 0) {
            this.insd.addOSSpec("NAME", os);
        }
        if ((jdkVersion = this.environmentPage.jdkVersionCombo.getText()) != null && jdkVersion.trim().length() > 0) {
            this.insd.addToolkitsSpec("JDK_VERSION", jdkVersion);
        }
    }

    private void addEnvVars() {
        this.insd.deleteInstallationActions("set_env_variable");
        for (VarVal vv : this.environmentPage.envVarList.tableRows) {
            String envVarName = vv.getVarName();
            String envVarValue = vv.getVarValue();
            if (envVarName == null || envVarValue == null || envVarName.trim().length() <= 0 || envVarValue.trim().length() <= 0) continue;
            InstallationDescriptor.ActionInfo actionInfo = new InstallationDescriptor.ActionInfo("set_env_variable");
            actionInfo.params.put("VAR_NAME", envVarName);
            actionInfo.params.put("VAR_VALUE", envVarValue);
            actionInfo.params.put("COMMENTS", "");
            this.insd.addInstallationAction(actionInfo);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }
}

