/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.uima.ruta.cde.ui.ResultViewContentProvder;
import org.apache.uima.ruta.cde.ui.ResultViewLabelProvider;
import org.apache.uima.ruta.cde.utils.CDEComparatorFactory;
import org.apache.uima.ruta.cde.utils.DocumentData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ResultViewComposite
extends Composite
implements ISelectionListener {
    private Clipboard clipboard;
    private TableViewer tableViewer;
    private Table table;
    private TableColumn tc1;
    private TableColumn tc2;
    private CDEComparatorFactory comparatorFactory;

    public ResultViewComposite(Composite parent, int style) {
        super(parent, style);
        this.initGui();
        this.comparatorFactory = new CDEComparatorFactory();
        this.clipboard = new Clipboard(parent.getDisplay());
    }

    public void initGui() {
        this.setLayout((Layout)new FormLayout());
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.tableViewer.setContentProvider((IContentProvider)new ResultViewContentProvder());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ResultViewLabelProvider());
        this.table = this.tableViewer.getTable();
        FormData tableFormData = new FormData();
        tableFormData.top = new FormAttachment(0, 5);
        tableFormData.left = new FormAttachment(0, 5);
        tableFormData.bottom = new FormAttachment(100, -5);
        tableFormData.right = new FormAttachment(100, -5);
        this.table.setLayoutData((Object)tableFormData);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99) {
                    TableItem[] items;
                    String output = "";
                    for (TableItem item : items = ResultViewComposite.this.table.getSelection()) {
                        String[] data = (String[])item.getData();
                        output = output + data[0] + ", " + data[1] + ", \n";
                    }
                    ResultViewComposite.this.clipboard.setContents(new Object[]{output}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tc1 = new TableColumn(this.table, 16384);
        this.tc1.setText("Constraint ");
        this.tc1.setWidth(160);
        this.tc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArrayList data = (ArrayList)ResultViewComposite.this.tableViewer.getInput();
                Comparator comparator = ResultViewComposite.this.comparatorFactory.getComparator(ResultViewComposite.this.tc1);
                Collections.sort(data, comparator);
                ResultViewComposite.this.tableViewer.refresh();
            }
        });
        this.tc2 = new TableColumn(this.table, 16384);
        this.tc2.setText("Result");
        this.tc2.setWidth(120);
        this.tc2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArrayList data = (ArrayList)ResultViewComposite.this.tableViewer.getInput();
                Comparator comparator = ResultViewComposite.this.comparatorFactory.getComparator(ResultViewComposite.this.tc2);
                Collections.sort(data, comparator);
                ResultViewComposite.this.tableViewer.refresh();
            }
        });
        this.tableViewer.refresh();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
    }

    public void updateInput(Object input) {
        this.tableViewer.setInput(input);
        this.tableViewer.refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        IStructuredSelection strucSel;
        Iterator iter;
        if (selection instanceof IStructuredSelection && (iter = (strucSel = (IStructuredSelection)selection).iterator()).hasNext() && (o = iter.next()) instanceof DocumentData) {
            DocumentData data = (DocumentData)o;
            ArrayList<String[]> results = data.getResults();
            this.tableViewer.setInput(results);
            this.tableViewer.refresh();
        }
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }
}

