/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorFactory {
    private static ScheduledExecutorService s_scheduler;

    public static ExecutorService createThreadPool(String name, int numberOfThreads) {
        return Executors.newFixedThreadPool(numberOfThreads, new NamedThreadFactory(name));
    }

    public static ExecutorService createCachedThreadPool(String name) {
        return Executors.newCachedThreadPool(new NamedThreadFactory(name));
    }

    public static synchronized ScheduledExecutorService getUtilityScheduledExecutor() {
        if (s_scheduler == null) {
            s_scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("scheduler"));
        }
        return s_scheduler;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup m_group;
        private final AtomicInteger m_threadNumber = new AtomicInteger(1);

        NamedThreadFactory(String name) {
            this.m_group = new ThreadGroup(name);
            this.m_group.setDaemon(true);
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String threadName = this.m_group.getName() + "-" + this.m_threadNumber.getAndIncrement();
            return new Thread(this.m_group, runnable, threadName);
        }
    }
}

