/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BufferedEchoMessageEncoder
extends EchoEncoder<ILoggingEvent> {
    private static final byte[] LINE_SEPARATOR_BYTES = CoreConstants.LINE_SEPARATOR.getBytes();
    private int m_bufferSize = 65536;

    public void init(OutputStream os) throws IOException {
        super.init((OutputStream)new BufferedOutputStream(os, this.getBufferSize()));
    }

    public void doEncode(ILoggingEvent event) throws IOException {
        this.outputStream.write(event.getMessage().getBytes());
        this.outputStream.write(LINE_SEPARATOR_BYTES);
    }

    public void close() throws IOException {
        super.close();
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.addStatus((Status)new ErrorStatus("Failed to flush buffer", (Object)this, (Throwable)e));
        }
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (this.outputStream != null) {
            throw new IllegalStateException("Already initialised");
        }
        this.m_bufferSize = bufferSize;
    }
}

