/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.grinder.common.Closer;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public class StreamCopier {
    private final byte[] m_buffer;
    private final boolean m_closeStreams;

    public StreamCopier(int bufferSize, boolean closeStreams) {
        this.m_buffer = new byte[bufferSize];
        this.m_closeStreams = closeStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int bytesRead;
            while ((bytesRead = in.read(this.m_buffer, 0, this.m_buffer.length)) != -1) {
                out.write(this.m_buffer, 0, bytesRead);
                out.flush();
            }
        }
        finally {
            if (this.m_closeStreams) {
                Closer.close(out);
                Closer.close(in);
            }
        }
    }

    public InterruptibleRunnable getInterruptibleRunnable(final InputStream in, final OutputStream out) {
        return new InterruptibleRunnable(){

            @Override
            public void interruptibleRun() {
                try {
                    StreamCopier.this.copy(in, out);
                }
                catch (IOException e) {
                    UncheckedInterruptedException.ioException(e);
                }
            }
        };
    }

    public Runnable getRunnable(InputStream in, OutputStream out) {
        return new InterruptibleRunnableAdapter(this.getInterruptibleRunnable(in, out));
    }
}

