/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.grinder.util.Sleeper;
import net.grinder.util.TimeAuthority;
import net.grinder.util.thread.Condition;
import org.slf4j.Logger;

public final class SleeperImplementation
implements Sleeper {
    private static final Random s_random = new Random();
    private static final List<WeakReference<SleeperImplementation>> s_allSleepers = new ArrayList<WeakReference<SleeperImplementation>>();
    private final TimeAuthority m_timeAuthority;
    private final double m_factor;
    private final double m_limit9975Factor;
    private final Logger m_logger;
    private final Condition m_condition = new Condition();
    private boolean m_shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SleeperImplementation(TimeAuthority timeAuthority, Logger logger, double factor, double limit9975Factor) {
        if (factor < 0.0 || limit9975Factor < 0.0) {
            throw new IllegalArgumentException("Factors must be positive");
        }
        Class<SleeperImplementation> clazz = SleeperImplementation.class;
        synchronized (SleeperImplementation.class) {
            s_allSleepers.add(new WeakReference<SleeperImplementation>(this));
            // ** MonitorExit[var7_5] (shouldn't be in output)
            this.m_timeAuthority = timeAuthority;
            this.m_factor = factor;
            this.m_limit9975Factor = limit9975Factor;
            this.m_logger = logger;
            return;
        }
    }

    public static synchronized void shutdownAllCurrentSleepers() {
        for (WeakReference<SleeperImplementation> reference : s_allSleepers) {
            Sleeper sleeper = (Sleeper)reference.get();
            if (sleeper == null) continue;
            sleeper.shutdown();
        }
        s_allSleepers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Condition condition = this.m_condition;
        synchronized (condition) {
            this.m_shutdown = true;
            this.m_condition.notifyAll();
        }
    }

    @Override
    public long getTimeInMilliseconds() {
        return this.m_timeAuthority.getTimeInMilliseconds();
    }

    @Override
    public void sleepNormal(long meanTime) throws Sleeper.ShutdownException {
        this.sleepNormal(meanTime, (long)((double)meanTime * this.m_limit9975Factor / 3.0));
    }

    @Override
    public void sleepNormal(long meanTime, long sigma) throws Sleeper.ShutdownException {
        this.checkShutdown();
        if (meanTime > 0L) {
            if (sigma > 0L) {
                this.doSleep(meanTime + (long)(s_random.nextGaussian() * (double)sigma));
            } else {
                this.doSleep(meanTime);
            }
        }
    }

    @Override
    public void sleepFlat(long maximumTime) throws Sleeper.ShutdownException {
        this.checkShutdown();
        if (maximumTime > 0L) {
            this.doSleep(Math.abs(s_random.nextLong()) % maximumTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSleep(long time) throws Sleeper.ShutdownException {
        long factoredTime = (long)((double)time * this.m_factor);
        if (this.m_logger != null) {
            this.m_logger.info("sleeping for {} ms", (Object)factoredTime);
        }
        if (time > 0L) {
            long currentTime = this.m_timeAuthority.getTimeInMilliseconds();
            long wakeUpTime = currentTime + factoredTime;
            while (currentTime < wakeUpTime) {
                Condition condition = this.m_condition;
                synchronized (condition) {
                    this.checkShutdown();
                    this.m_condition.waitNoInterrruptException(wakeUpTime - currentTime);
                }
                currentTime = this.m_timeAuthority.getTimeInMilliseconds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() throws Sleeper.ShutdownException {
        Condition condition = this.m_condition;
        synchronized (condition) {
            if (this.m_shutdown) {
                throw new Sleeper.ShutdownException("Shut down");
            }
        }
    }
}

