/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;

public class SignificantFigureFormat
extends DecimalFormat {
    private static final long serialVersionUID = 1L;
    private static final int s_decimalPlaces = 40;
    private final int m_significantFigures;

    public SignificantFigureFormat(int significantFigures) {
        super("0.0000000000000000000000000000000000000000");
        this.m_significantFigures = significantFigures;
    }

    private static int boundingPowerOfTen(double number) {
        if (number == 0.0 || Double.isInfinite(number) || Double.isNaN(number)) {
            return 1;
        }
        double abs = Math.abs(number);
        int i = 0;
        double x = 1.0;
        if (abs < 1.0) {
            while (x > abs) {
                x /= 10.0;
                --i;
            }
            return i + 1;
        }
        while (!(x > abs)) {
            x *= 10.0;
            ++i;
        }
        return i;
    }

    @Override
    public StringBuffer format(double number, StringBuffer buffer, FieldPosition position) {
        if (Double.isInfinite(number) || Double.isNaN(number)) {
            return super.format(number, buffer, position);
        }
        int shift = SignificantFigureFormat.boundingPowerOfTen(number) - this.m_significantFigures;
        double factor = Math.pow(10.0, shift);
        super.format(factor * (double)Math.round(number / factor), buffer, position);
        int truncate = shift < 0 ? 40 + shift : 41;
        buffer.setLength(buffer.length() - truncate);
        return buffer;
    }

    @Override
    public StringBuffer format(long number, StringBuffer buffer, FieldPosition position) {
        return this.format((double)number, buffer, position);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return super.equals(o) && this.m_significantFigures == ((SignificantFigureFormat)o).m_significantFigures;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

