/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.grinder.common.GrinderException;

public final class BooleanProperty {
    private final Object m_bean;
    private final Class<?> m_beanClass;
    private final PropertyDescriptor m_propertyDescriptor;

    public BooleanProperty(Object bean, String propertyName) throws PropertyException {
        this.m_bean = bean;
        this.m_beanClass = bean.getClass();
        try {
            this.m_propertyDescriptor = new PropertyDescriptor(propertyName, this.m_beanClass);
        }
        catch (IntrospectionException e) {
            throw new PropertyException("Could not find property '" + propertyName + "' in class '" + this.m_beanClass + "'", e);
        }
        Class<?> propertyType = this.m_propertyDescriptor.getPropertyType();
        if (!propertyType.equals(Boolean.TYPE) && !propertyType.equals(Boolean.class)) {
            throw new PropertyException(this.toString() + ": property is not boolean");
        }
    }

    public boolean get() throws PropertyException {
        Method readMethod = this.m_propertyDescriptor.getReadMethod();
        try {
            Boolean result = (Boolean)readMethod.invoke(this.m_bean, new Object[0]);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(this.toString() + ": could not read", e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyException(this.toString() + ": could not read", e.getTargetException());
        }
    }

    public void set(boolean value) throws PropertyException {
        Method writeMethod = this.m_propertyDescriptor.getWriteMethod();
        try {
            writeMethod.invoke(this.m_bean, value ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(this.toString() + ": could not write", e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyException(this.toString() + ": could not write", e.getTargetException());
        }
    }

    public String toString() {
        return this.m_beanClass.getName() + "." + this.m_propertyDescriptor.getName();
    }

    public static final class PropertyException
    extends GrinderException {
        private PropertyException(String message) {
            super(message);
        }

        private PropertyException(String message, Throwable t) {
            super(message, t);
        }
    }
}

