/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.util.AttributeStringParser;

public final class AttributeStringParserImplementation
implements AttributeStringParser {
    private final Pattern m_nameValuePattern = Pattern.compile("(\\w+)\\s*=\\s*['\"](.*?)['\"]");

    @Override
    public AttributeStringParser.AttributeMap parse(String string) {
        Matcher matcher = this.m_nameValuePattern.matcher(string);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            map.put(matcher.group(1).toLowerCase(), matcher.group(2));
        }
        return new AttributeMapImplementation(map);
    }

    private static final class AttributeMapImplementation
    implements AttributeStringParser.AttributeMap {
        private final Map<String, String> m_map;

        public AttributeMapImplementation(Map<String, String> map) {
            this.m_map = map;
        }

        @Override
        public String get(String key) {
            return this.m_map.get(key.toLowerCase());
        }
    }
}

