/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import net.grinder.common.GrinderException;
import net.grinder.util.FixedWidthFormatter;
import net.grinder.util.JVM;
import org.slf4j.Logger;

public abstract class AbstractMainClass {
    private final String m_usage;
    private final Logger m_logger;

    protected AbstractMainClass(Logger logger, String usage) throws GrinderException {
        this.m_usage = new FixedWidthFormatter(FixedWidthFormatter.Align.LEFT, FixedWidthFormatter.Flow.WORD_WRAP, 80).format(usage);
        this.m_logger = logger;
        if (!JVM.getInstance().haveRequisites(this.m_logger)) {
            throw new LoggedInitialisationException("Unsupported JVM");
        }
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected final LoggedInitialisationException barfError(String message) {
        this.m_logger.error(message);
        return new LoggedInitialisationException(message);
    }

    protected final LoggedInitialisationException barfUsage() {
        return this.barfError("Unrecognised or invalid option.\n\nUsage:\n" + this.m_usage);
    }

    protected static class LoggedInitialisationException
    extends GrinderException {
        public LoggedInitialisationException(String message) {
            super(message);
        }
    }
}

