/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.synchronisation;

import java.util.Set;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.Sender;
import net.grinder.synchronisation.AbstractBarrierGroups;
import net.grinder.synchronisation.messages.AddBarrierMessage;
import net.grinder.synchronisation.messages.AddWaiterMessage;
import net.grinder.synchronisation.messages.BarrierIdentity;
import net.grinder.synchronisation.messages.CancelWaiterMessage;
import net.grinder.synchronisation.messages.OpenBarrierMessage;
import net.grinder.synchronisation.messages.RemoveBarriersMessage;

public class ClientBarrierGroups
extends AbstractBarrierGroups {
    private final Sender m_sender;

    public ClientBarrierGroups(Sender sender, MessageDispatchRegistry messageDispatch) {
        this.m_sender = sender;
        messageDispatch.set(OpenBarrierMessage.class, new MessageDispatchRegistry.AbstractHandler<OpenBarrierMessage>(){

            @Override
            public void handle(OpenBarrierMessage message) {
                AbstractBarrierGroups.BarrierGroupImplementation existingGroup = ClientBarrierGroups.this.getExistingGroup(message.getName());
                if (existingGroup != null) {
                    Set<BarrierIdentity> removedWaiters = existingGroup.clearWaiters(message.getWaiters());
                    existingGroup.fireAwaken(removedWaiters);
                }
            }
        });
    }

    @Override
    protected AbstractBarrierGroups.BarrierGroupImplementation createBarrierGroup(String name) {
        return new AbstractBarrierGroups.BarrierGroupImplementation(name){

            @Override
            public void addBarrier() throws CommunicationException {
                super.addBarrier();
                ClientBarrierGroups.this.m_sender.send(new AddBarrierMessage(this.getName()));
            }

            @Override
            public void removeBarriers(long n) throws CommunicationException {
                super.removeBarriers(n);
                ClientBarrierGroups.this.m_sender.send(new RemoveBarriersMessage(this.getName(), n));
            }

            @Override
            public void addWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
                super.addWaiter(barrierIdentity);
                ClientBarrierGroups.this.m_sender.send(new AddWaiterMessage(this.getName(), barrierIdentity));
            }

            @Override
            public void cancelWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
                super.cancelWaiter(barrierIdentity);
                ClientBarrierGroups.this.m_sender.send(new CancelWaiterMessage(this.getName(), barrierIdentity));
            }
        };
    }
}

