/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.synchronisation;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import net.grinder.synchronisation.messages.BarrierIdentity;

public final class BarrierIdentityGenerator
implements BarrierIdentity.Factory {
    private final AtomicInteger m_next = new AtomicInteger();
    private final Serializable m_scope;

    public BarrierIdentityGenerator(Serializable scope) {
        this.m_scope = scope;
    }

    @Override
    public BarrierIdentity next() {
        return new BarrierIdentityImplementation(this.m_scope, this.m_next.getAndIncrement());
    }

    static final class BarrierIdentityImplementation
    implements BarrierIdentity {
        private static final long serialVersionUID = 1L;
        private final Serializable m_scope;
        private final int m_value;

        public BarrierIdentityImplementation(Serializable scope, int value) {
            this.m_scope = scope;
            this.m_value = value;
        }

        public int hashCode() {
            return this.m_value * 17 + this.m_scope.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BarrierIdentityImplementation other = (BarrierIdentityImplementation)o;
            return this.m_value == other.m_value && this.m_scope.equals(other.m_scope);
        }

        public String toString() {
            return "BarrierIdentity[" + this.m_scope + ", " + this.m_value + "]";
        }
    }
}

