/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.synchronisation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.grinder.communication.CommunicationException;
import net.grinder.synchronisation.BarrierGroup;
import net.grinder.synchronisation.BarrierGroups;
import net.grinder.synchronisation.messages.BarrierIdentity;
import net.grinder.util.ListenerSupport;

public abstract class AbstractBarrierGroups
implements BarrierGroups {
    private final Map<String, BarrierGroupImplementation> m_groups = new HashMap<String, BarrierGroupImplementation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BarrierGroup getGroup(String name) {
        Map<String, BarrierGroupImplementation> map = this.m_groups;
        synchronized (map) {
            BarrierGroup existing = this.m_groups.get(name);
            if (existing != null) {
                return existing;
            }
            BarrierGroupImplementation newInstance = this.createBarrierGroup(name);
            this.m_groups.put(name, newInstance);
            return newInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAll() throws CommunicationException {
        Map<String, BarrierGroupImplementation> map = this.m_groups;
        synchronized (map) {
            HashSet<BarrierGroupImplementation> clonedGroups = new HashSet<BarrierGroupImplementation>(this.m_groups.values());
            for (BarrierGroupImplementation group : clonedGroups) {
                group.cancelAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BarrierGroupImplementation getExistingGroup(String name) {
        Map<String, BarrierGroupImplementation> map = this.m_groups;
        synchronized (map) {
            return this.m_groups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBarrierGroup(BarrierGroup barrierGroup) {
        Map<String, BarrierGroupImplementation> map = this.m_groups;
        synchronized (map) {
            this.m_groups.remove(barrierGroup.getName());
        }
    }

    protected abstract BarrierGroupImplementation createBarrierGroup(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, BarrierGroupImplementation> map = this.m_groups;
        synchronized (map) {
            return this.getClass().getSimpleName() + "[" + this.m_groups + "]";
        }
    }

    protected class BarrierGroupImplementation
    implements BarrierGroup {
        private final String m_name;
        private final ListenerSupport<BarrierGroup.Listener> m_listeners = new ListenerSupport();
        private long m_barriers = 0L;
        private final Set<BarrierIdentity> m_waiters = new HashSet<BarrierIdentity>();

        public BarrierGroupImplementation(String name) {
            this.m_name = name;
        }

        private void checkValid() {
            if (this.m_barriers < 0L) {
                throw new IllegalStateException("BarrierGroup is invalid");
            }
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        @Override
        public void addListener(BarrierGroup.Listener listener) {
            this.m_listeners.add(listener);
        }

        @Override
        public void removeListener(BarrierGroup.Listener listener) {
            this.m_listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBarrier() throws CommunicationException {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                this.checkValid();
                ++this.m_barriers;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeBarriers(long n) throws CommunicationException {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                this.checkValid();
                if (n > this.m_barriers - (long)this.m_waiters.size()) {
                    throw new IllegalStateException("Can't remove " + n + " barriers from " + this.m_barriers + " barriers, " + this.m_waiters.size() + " waiters");
                }
                this.m_barriers -= n;
                if (this.m_barriers == 0L) {
                    AbstractBarrierGroups.this.removeBarrierGroup(this);
                    this.m_barriers = -1L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                this.checkValid();
                if (this.m_barriers == 0L) {
                    throw new IllegalStateException("Can't add waiter, no barriers");
                }
                if ((long)this.m_waiters.size() >= this.m_barriers) {
                    throw new AssertionError((Object)this.toString());
                }
                this.m_waiters.add(barrierIdentity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                this.m_waiters.remove(barrierIdentity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelAll() throws CommunicationException {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                HashSet<BarrierIdentity> clonedWaiters = new HashSet<BarrierIdentity>(this.m_waiters);
                for (BarrierIdentity barrierIdentity : clonedWaiters) {
                    this.cancelWaiter(barrierIdentity);
                }
                this.removeBarriers(this.m_barriers);
            }
        }

        protected final void fireAwaken(final Set<BarrierIdentity> oldWaiters) {
            this.m_listeners.apply(new ListenerSupport.Informer<BarrierGroup.Listener>(){

                @Override
                public void inform(BarrierGroup.Listener listener) {
                    listener.awaken(oldWaiters);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Set<BarrierIdentity> clearWaiters(Set<BarrierIdentity> waiters) {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                HashSet<BarrierIdentity> removed = new HashSet<BarrierIdentity>(this.m_waiters.size());
                for (BarrierIdentity waiter : waiters) {
                    if (!this.m_waiters.remove(waiter)) continue;
                    removed.add(waiter);
                }
                return removed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Set<BarrierIdentity> checkCondition() {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                if (this.m_barriers > 0L && this.m_barriers == (long)this.m_waiters.size()) {
                    HashSet<BarrierIdentity> result = new HashSet<BarrierIdentity>(this.m_waiters);
                    this.m_waiters.clear();
                    return result;
                }
                return Collections.emptySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            BarrierGroupImplementation barrierGroupImplementation = this;
            synchronized (barrierGroupImplementation) {
                if (this.m_barriers < 0L) {
                    return "(cancelled)";
                }
                return "(" + this.m_barriers + " " + this.m_waiters + ")";
            }
        }
    }
}

