/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import net.grinder.common.Test;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsView;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.FixedWidthFormatter;

public class StatisticsTable {
    private static final int COLUMN_WIDTH = 12;
    private static final String COLUMN_SEPARATOR = " ";
    private final TestStatisticsMap m_testStatisticsMap;
    private final DecimalFormat m_twoDPFormat = new DecimalFormat("0.00");
    private final String m_lineSeparator = System.getProperty("line.separator");
    private final FixedWidthFormatter m_headingFormatter = new FixedWidthFormatter(FixedWidthFormatter.Align.LEFT, FixedWidthFormatter.Flow.WORD_WRAP, 12);
    private final FixedWidthFormatter m_rowLabelFormatter = new FixedWidthFormatter(FixedWidthFormatter.Align.LEFT, FixedWidthFormatter.Flow.OVERFLOW, 12);
    private final FixedWidthFormatter m_rowCellFormatter = new FixedWidthFormatter(FixedWidthFormatter.Align.LEFT, FixedWidthFormatter.Flow.TRUNCATE, 12);
    private final FixedWidthFormatter m_freeTextFormatter = new FixedWidthFormatter(FixedWidthFormatter.Align.LEFT, FixedWidthFormatter.Flow.WORD_WRAP, 72);
    private final StatisticsView m_statisticsView;
    private final StatisticsIndexMap.LongIndex m_periodIndex;

    public StatisticsTable(StatisticsView statisticsView, StatisticsIndexMap statisticsIndexMap, TestStatisticsMap testStatisticsMap) {
        this.m_statisticsView = statisticsView;
        this.m_testStatisticsMap = testStatisticsMap;
        this.m_periodIndex = statisticsIndexMap.getLongIndex("period");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(final PrintWriter out, final long elapsedTime) {
        boolean wrapped;
        ExpressionView[] expressionViews = this.m_statisticsView.getExpressionViews();
        int numberOfHeaderColumns = expressionViews.length + 1;
        StringBuilder[] cells = new StringBuilder[numberOfHeaderColumns];
        StringBuilder[] remainders = new StringBuilder[numberOfHeaderColumns];
        for (int i = 0; i < numberOfHeaderColumns; ++i) {
            cells[i] = new StringBuilder(i == 0 ? "" : expressionViews[i - 1].getDisplayName());
            remainders[i] = new StringBuilder();
        }
        do {
            wrapped = false;
            for (int i = 0; i < numberOfHeaderColumns; ++i) {
                remainders[i].setLength(0);
                this.m_headingFormatter.transform(cells[i], remainders[i]);
                out.print(cells[i].toString());
                out.print(COLUMN_SEPARATOR);
                if (remainders[i].length() <= 0) continue;
                wrapped = true;
            }
            out.println();
            StringBuilder[] otherArray = cells;
            cells = remainders;
            remainders = otherArray;
        } while (wrapped);
        out.println();
        final LineFormatter formatter = new LineFormatter(expressionViews);
        CompositeStatisticsLineFormater compositeTotalsFormatter = new CompositeStatisticsLineFormater(expressionViews);
        TestStatisticsMap testStatisticsMap = this.m_testStatisticsMap;
        synchronized (testStatisticsMap) {
            TestStatisticsMap testStatisticsMap2 = this.m_testStatisticsMap;
            testStatisticsMap2.getClass();
            new TestStatisticsMap.ForEach(testStatisticsMap2){

                @Override
                public void next(Test test, StatisticsSet statistics) {
                    statistics.setValue(StatisticsTable.this.m_periodIndex, elapsedTime);
                    out.print(formatter.format("Test " + test.getNumber(), statistics));
                    String testDescription = test.getDescription();
                    if (testDescription != null) {
                        out.println(" \"" + testDescription + "\"");
                    } else {
                        out.println();
                    }
                }
            }.iterate();
            out.println();
            StatisticsSet nonCompositeStatisticsTotals = this.m_testStatisticsMap.nonCompositeStatisticsTotals();
            nonCompositeStatisticsTotals.setValue(this.m_periodIndex, elapsedTime);
            out.println(formatter.format("Totals", nonCompositeStatisticsTotals));
            StatisticsSet compositeStatisticsTotals = this.m_testStatisticsMap.compositeStatisticsTotals();
            if (!compositeStatisticsTotals.isZero()) {
                compositeStatisticsTotals.setValue(this.m_periodIndex, elapsedTime);
                out.println(compositeTotalsFormatter.format("", compositeStatisticsTotals));
            }
        }
        out.println();
        StringBuilder text = new StringBuilder();
        StringBuilder buffer = new StringBuilder("Tests resulting in error only contribute to the Errors column. Statistics for individual tests can be found in the data file, including (possibly incomplete) statistics for erroneous tests. Composite tests are marked with () and not included in the totals.");
        while (buffer.length() > 0) {
            StringBuilder remainder = new StringBuilder();
            this.m_freeTextFormatter.transform(buffer, remainder);
            if (text.length() > 0) {
                text.append(this.m_lineSeparator);
            }
            text.append("  ");
            text.append(buffer.toString());
            buffer = remainder;
        }
        out.println(text);
    }

    private class CompositeStatisticsLineFormater
    extends LineFormatter {
        public CompositeStatisticsLineFormater(ExpressionView[] expressionViews) {
            super(expressionViews);
        }

        @Override
        protected String formatExpression(ExpressionView expressionView, StatisticsSet statistics) {
            if (expressionView.getShowForCompositeStatistics()) {
                StringBuilder result = new StringBuilder("(");
                result.append(super.formatExpression(expressionView, statistics));
                result.append(")");
                return result.toString();
            }
            return "";
        }

        @Override
        protected String startOfLine(StatisticsSet statistics) {
            return "";
        }

        @Override
        protected String endOfLine(StatisticsSet statistics) {
            return "";
        }
    }

    private class LineFormatter {
        private final ExpressionView[] m_expressionViews;

        public LineFormatter(ExpressionView[] expressionViews) {
            this.m_expressionViews = expressionViews;
        }

        public String format(String rowLabel, StatisticsSet statistics) {
            StringBuilder result = new StringBuilder();
            StringBuilder cell = new StringBuilder();
            cell.append(this.startOfLine(statistics));
            cell.append(rowLabel);
            StringBuilder remainder = new StringBuilder();
            StatisticsTable.this.m_rowLabelFormatter.transform(cell, remainder);
            result.append(cell.toString());
            result.append(StatisticsTable.COLUMN_SEPARATOR);
            for (int i = 0; i < this.m_expressionViews.length; ++i) {
                StringBuilder statisticsCell = new StringBuilder(this.formatExpression(this.m_expressionViews[i], statistics));
                if (i == this.m_expressionViews.length - 1) {
                    statisticsCell.append(this.endOfLine(statistics));
                }
                StatisticsTable.this.m_rowCellFormatter.transform(statisticsCell, remainder);
                result.append(statisticsCell.toString());
                result.append(StatisticsTable.COLUMN_SEPARATOR);
            }
            return result.toString();
        }

        protected String startOfLine(StatisticsSet statistics) {
            if (statistics.isComposite()) {
                return "(";
            }
            return "";
        }

        protected String endOfLine(StatisticsSet statistics) {
            if (statistics.isComposite()) {
                return ")";
            }
            return "";
        }

        protected String formatExpression(ExpressionView expressionView, StatisticsSet statistics) {
            StatisticExpression expression = expressionView.getExpression();
            if (expression.isDouble()) {
                double value = expression.getDoubleValue(statistics);
                if (Double.isNaN(value)) {
                    return "-";
                }
                return StatisticsTable.this.m_twoDPFormat.format(value);
            }
            return String.valueOf(expression.getLongValue(statistics));
        }
    }
}

