/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import net.grinder.statistics.ImmutableStatisticsSet;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.Serialiser;

final class StatisticsSetImplementation
implements StatisticsSet {
    private final StatisticsIndexMap m_statisticsIndexMap;
    private final long[] m_longData;
    private final double[] m_doubleData;
    private transient long[] m_transientLongData;
    private boolean m_zero = true;
    private boolean m_composite;

    StatisticsSetImplementation(StatisticsIndexMap statisticsIndexMap) {
        this.m_statisticsIndexMap = statisticsIndexMap;
        this.m_longData = new long[this.m_statisticsIndexMap.getNumberOfLongs()];
        this.m_doubleData = new double[this.m_statisticsIndexMap.getNumberOfDoubles()];
        this.m_transientLongData = new long[this.m_statisticsIndexMap.getNumberOfTransientLongs()];
    }

    @Override
    public synchronized void reset() {
        if (!this.m_zero) {
            Arrays.fill(this.m_longData, 0L);
            Arrays.fill(this.m_doubleData, 0.0);
            Arrays.fill(this.m_transientLongData, 0L);
            this.m_zero = true;
            this.m_composite = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized StatisticsSet snapshot() {
        StatisticsSetImplementation result = new StatisticsSetImplementation(this.m_statisticsIndexMap);
        if (!this.m_zero) {
            StatisticsSetImplementation statisticsSetImplementation = result;
            synchronized (statisticsSetImplementation) {
                System.arraycopy(this.m_longData, 0, result.m_longData, 0, result.m_longData.length);
                System.arraycopy(this.m_doubleData, 0, result.m_doubleData, 0, result.m_doubleData.length);
                System.arraycopy(this.m_transientLongData, 0, result.m_transientLongData, 0, result.m_transientLongData.length);
                result.m_zero = false;
                result.m_composite = this.m_composite;
            }
        }
        return result;
    }

    @Override
    public synchronized long getValue(StatisticsIndexMap.LongIndex index) {
        if (index.isTransient()) {
            return this.m_transientLongData[index.getValue()];
        }
        return this.m_longData[index.getValue()];
    }

    @Override
    public synchronized double getValue(StatisticsIndexMap.DoubleIndex index) {
        return this.m_doubleData[index.getValue()];
    }

    @Override
    public synchronized void setValue(StatisticsIndexMap.LongIndex index, long value) {
        if (index.isTransient()) {
            this.m_transientLongData[index.getValue()] = value;
        } else {
            this.m_longData[index.getValue()] = value;
        }
        this.m_zero &= value == 0L;
    }

    @Override
    public synchronized void setValue(StatisticsIndexMap.DoubleIndex index, double value) {
        this.m_doubleData[index.getValue()] = value;
        this.m_zero &= value == 0.0;
    }

    @Override
    public synchronized void addValue(StatisticsIndexMap.LongIndex index, long value) {
        if (!index.isTransient()) {
            int n = index.getValue();
            this.m_longData[n] = this.m_longData[n] + value;
            this.m_zero &= value == 0L;
        }
    }

    @Override
    public synchronized void addValue(StatisticsIndexMap.DoubleIndex index, double value) {
        int n = index.getValue();
        this.m_doubleData[n] = this.m_doubleData[n] + value;
        this.m_zero &= value == 0.0;
    }

    @Override
    public synchronized void addSample(StatisticsIndexMap.LongSampleIndex index, long value) {
        this.setValue(index.getVarianceIndex(), this.calculateVariance(this.getValue(index.getSumIndex()), this.getValue(index.getCountIndex()), this.getValue(index.getVarianceIndex()), value));
        int n = index.getSumIndex().getValue();
        this.m_longData[n] = this.m_longData[n] + value;
        int n2 = index.getCountIndex().getValue();
        this.m_longData[n2] = this.m_longData[n2] + 1L;
        this.m_zero = false;
    }

    @Override
    public synchronized void addSample(StatisticsIndexMap.DoubleSampleIndex index, double value) {
        this.setValue(index.getVarianceIndex(), this.calculateVariance(this.getValue(index.getSumIndex()), this.getValue(index.getCountIndex()), this.getValue(index.getVarianceIndex()), value));
        int n = index.getSumIndex().getValue();
        this.m_doubleData[n] = this.m_doubleData[n] + value;
        int n2 = index.getCountIndex().getValue();
        this.m_longData[n2] = this.m_longData[n2] + 1L;
        this.m_zero = false;
    }

    @Override
    public synchronized void reset(StatisticsIndexMap.LongSampleIndex index) {
        this.setValue(index.getSumIndex(), 0L);
        this.setValue(index.getCountIndex(), 0L);
        this.setValue(index.getVarianceIndex(), 0.0);
    }

    @Override
    public synchronized void reset(StatisticsIndexMap.DoubleSampleIndex index) {
        this.setValue(index.getSumIndex(), 0.0);
        this.setValue(index.getCountIndex(), 0L);
        this.setValue(index.getVarianceIndex(), 0.0);
    }

    private double calculateVariance(double sum, long count, double variance, double newValue) {
        if (count == 0L) {
            return 0.0;
        }
        long t1 = count + 1L;
        double t2 = newValue - sum / (double)count;
        return (double)count * variance / (double)(count + 1L) + (double)count / (double)(t1 * t1) * t2 * t2;
    }

    private double calculateVariance(double s1, long n1, double v1, double s2, long n2, double v2) {
        if (n1 == 0L) {
            return v2;
        }
        if (n2 == 0L) {
            return v1;
        }
        double s = s1 + s2;
        long n = n1 + n2;
        double term1 = s1 / (double)n1 - s / (double)n;
        double term2 = s2 / (double)n2 - s / (double)n;
        return ((double)n1 * (term1 * term1 + v1) + (double)n2 * (term2 * term2 + v2)) / (double)n;
    }

    @Override
    public long getSum(StatisticsIndexMap.LongSampleIndex index) {
        return this.getValue(index.getSumIndex());
    }

    @Override
    public double getSum(StatisticsIndexMap.DoubleSampleIndex index) {
        return this.getValue(index.getSumIndex());
    }

    @Override
    public long getCount(StatisticsIndexMap.SampleIndex index) {
        return this.getValue(index.getCountIndex());
    }

    @Override
    public double getVariance(StatisticsIndexMap.SampleIndex index) {
        return this.getValue(index.getVarianceIndex());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void add(ImmutableStatisticsSet operand) {
        void var5_9;
        StatisticsIndexMap.DoubleIndex varianceIndex;
        StatisticsIndexMap.LongIndex countIndex;
        StatisticsIndexMap.AbstractSimpleIndex sumIndex;
        StatisticsSetImplementation operandImplementation = (StatisticsSetImplementation)operand;
        boolean[] isVarianceIndex = new boolean[this.m_doubleData.length];
        for (StatisticsIndexMap.LongSampleIndex longSampleIndex : this.m_statisticsIndexMap.getLongSampleIndicies()) {
            sumIndex = longSampleIndex.getSumIndex();
            countIndex = longSampleIndex.getCountIndex();
            varianceIndex = longSampleIndex.getVarianceIndex();
            this.setValue(varianceIndex, this.calculateVariance(this.getValue((StatisticsIndexMap.LongIndex)sumIndex), this.getValue(countIndex), this.getValue(varianceIndex), operand.getValue((StatisticsIndexMap.LongIndex)sumIndex), operand.getValue(countIndex), operand.getValue(varianceIndex)));
            isVarianceIndex[varianceIndex.getValue()] = true;
        }
        for (StatisticsIndexMap.DoubleSampleIndex doubleSampleIndex : this.m_statisticsIndexMap.getDoubleSampleIndicies()) {
            sumIndex = doubleSampleIndex.getSumIndex();
            countIndex = doubleSampleIndex.getCountIndex();
            varianceIndex = doubleSampleIndex.getVarianceIndex();
            this.setValue(varianceIndex, this.calculateVariance(this.getValue((StatisticsIndexMap.DoubleIndex)sumIndex), this.getValue(countIndex), this.getValue(varianceIndex), operand.getValue((StatisticsIndexMap.DoubleIndex)sumIndex), operand.getValue(countIndex), operand.getValue(varianceIndex)));
            isVarianceIndex[varianceIndex.getValue()] = true;
        }
        long[] longData = operandImplementation.m_longData;
        boolean bl = false;
        while (var5_9 < longData.length) {
            void v0 = var5_9;
            this.m_longData[v0] = this.m_longData[v0] + longData[var5_9];
            ++var5_9;
        }
        double[] dArray = operandImplementation.m_doubleData;
        for (int i = 0; i < dArray.length; ++i) {
            if (isVarianceIndex[i]) continue;
            int n = i;
            this.m_doubleData[n] = this.m_doubleData[n] + dArray[i];
        }
        this.m_zero = false;
        if (operand.isComposite()) {
            this.setIsComposite();
        }
    }

    @Override
    public synchronized boolean isZero() {
        return this.m_zero;
    }

    @Override
    public synchronized boolean isComposite() {
        return this.m_composite;
    }

    @Override
    public synchronized void setIsComposite() {
        this.m_composite = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object o) {
        StatisticsSetImplementation otherStatistics;
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != StatisticsSetImplementation.class) {
            return false;
        }
        StatisticsSetImplementation statisticsSetImplementation = otherStatistics = (StatisticsSetImplementation)o;
        synchronized (statisticsSetImplementation) {
            int i;
            if (this.m_composite != otherStatistics.m_composite) {
                return false;
            }
            long[] otherLongData = otherStatistics.m_longData;
            for (i = 0; i < this.m_longData.length; ++i) {
                if (this.m_longData[i] == otherLongData[i]) continue;
                return false;
            }
            for (i = 0; i < this.m_doubleData.length; ++i) {
                if (this.m_doubleData[i] == otherStatistics.m_doubleData[i]) continue;
                return false;
            }
            long[] otherTransientLongData = otherStatistics.m_transientLongData;
            for (int i2 = 0; i2 < this.m_transientLongData.length; ++i2) {
                if (this.m_transientLongData[i2] == otherTransientLongData[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        long result = 0L;
        for (i = 0; i < this.m_longData.length; ++i) {
            result ^= this.m_longData[i];
        }
        for (i = 0; i < this.m_doubleData.length; ++i) {
            result ^= Double.doubleToRawLongBits(this.m_doubleData[i]);
        }
        for (i = 0; i < this.m_transientLongData.length; ++i) {
            result ^= this.m_transientLongData[i];
        }
        return (int)(result ^ result >> 32);
    }

    public synchronized String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("StatisticsSet = {{");
        for (i = 0; i < this.m_longData.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.m_longData[i]);
        }
        result.append("}, {");
        for (i = 0; i < this.m_doubleData.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.m_doubleData[i]);
        }
        result.append("}, {");
        for (i = 0; i < this.m_transientLongData.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.m_transientLongData[i]);
        }
        result.append("}, composite = ");
        result.append(this.m_composite ? "true" : "false");
        result.append("}");
        return result.toString();
    }

    synchronized void writeExternal(ObjectOutput out, Serialiser serialiser) throws IOException {
        int i;
        for (i = 0; i < this.m_longData.length; ++i) {
            serialiser.writeLong(out, this.m_longData[i]);
        }
        for (i = 0; i < this.m_doubleData.length; ++i) {
            serialiser.writeDouble(out, this.m_doubleData[i]);
        }
        out.writeBoolean(this.m_composite);
    }

    StatisticsSetImplementation(StatisticsIndexMap statisticsIndexMap, ObjectInput in, Serialiser serialiser) throws IOException {
        this(statisticsIndexMap);
        int i;
        for (i = 0; i < this.m_longData.length; ++i) {
            this.m_longData[i] = serialiser.readLong(in);
            this.m_zero &= this.m_longData[i] == 0L;
        }
        for (i = 0; i < this.m_doubleData.length; ++i) {
            this.m_doubleData[i] = serialiser.readDouble(in);
            this.m_zero &= this.m_doubleData[i] == 0.0;
        }
        this.m_composite = in.readBoolean();
    }
}

