/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.jython.instrumentation.dcr;

import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Recorder;
import net.grinder.scriptengine.jython.instrumentation.dcr.AbstractJythonDCRInstrumenter;
import net.grinder.util.weave.Weaver;
import org.python.core.PyClass;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;

public final class Jython22Instrumenter
extends AbstractJythonDCRInstrumenter {
    public Jython22Instrumenter(DCRContext context) {
        super(context);
    }

    @Override
    public String getDescription() {
        return "byte code transforming instrumenter for Jython 2.1/2.2";
    }

    @Override
    protected void transform(Recorder recorder, PyInstance target) throws NonInstrumentableTypeException {
        this.instrumentPublicMethodsByName(target, "invoke", recorder, true);
    }

    @Override
    protected void transform(Recorder recorder, PyFunction target) throws NonInstrumentableTypeException {
        this.instrumentPublicMethodsByName(target, "__call__", recorder, false);
    }

    @Override
    protected void transform(Recorder recorder, PyClass target) throws NonInstrumentableTypeException {
        this.instrumentPublicMethodsByName(target, "__call__", recorder, false);
    }

    @Override
    protected void transform(Recorder recorder, PyProxy target) throws NonInstrumentableTypeException {
        PyObject pyInstance;
        try {
            pyInstance = (PyObject)target.getClass().getMethod("_getPyInstance", new Class[0]).invoke((Object)target, new Object[0]);
        }
        catch (Exception e) {
            throw new NonInstrumentableTypeException(e.getMessage(), e);
        }
        this.instrumentPublicMethodsByName(pyInstance, "invoke", recorder, true);
    }

    @Override
    protected void transform(Recorder recorder, PyMethod target) throws NonInstrumentableTypeException {
        if (target.im_self == null) {
            this.instrumentPublicMethodsByName(target.im_func, "__call__", recorder, false);
        } else {
            this.instrumentPublicMethodsByName(target.im_func.getClass(), target.im_self, "__call__", Weaver.TargetSource.SECOND_PARAMETER, recorder, false);
        }
    }
}

