/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.jython;

import java.io.File;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.ScriptExecutionException;
import net.grinder.scriptengine.jython.JythonScriptExecutionException;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

final class JythonScriptEngine
implements ScriptEngineService.ScriptEngine {
    private static final String PYTHON_HOME = "python.home";
    private static final String PYTHON_CACHEDIR = "python.cachedir";
    private static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    private static final String TEST_RUNNER_CALLABLE_NAME = "TestRunner";
    private final PySystemState m_systemState;
    private final PythonInterpreter m_interpreter;
    private final PyClass m_dieQuietly;
    private final String m_version;
    private final PyObject m_testRunnerFactory;

    public JythonScriptEngine(ScriptLocation script) throws EngineException {
        String version;
        if (System.getProperty(PYTHON_HOME) == null && System.getProperty(PYTHON_CACHEDIR) == null) {
            File jythonHome;
            String classpath = System.getProperty("java.class.path");
            File grinderJar = JythonScriptEngine.findFileInPath(classpath, "grinder.jar");
            File grinderJarDirectory = grinderJar != null ? grinderJar.getParentFile() : new File(".");
            File jythonJar = JythonScriptEngine.findFileInPath(classpath, "jython.jar");
            File file = jythonHome = jythonJar != null ? jythonJar.getParentFile() : grinderJarDirectory;
            if (grinderJarDirectory == null && jythonJar == null || grinderJarDirectory != null && grinderJarDirectory.equals(jythonHome)) {
                File cacheDir = new File(jythonHome, CACHEDIR_DEFAULT_NAME);
                System.setProperty(PYTHON_CACHEDIR, cacheDir.getAbsolutePath());
            }
        }
        this.m_systemState = new PySystemState();
        this.m_interpreter = new PythonInterpreter(null, this.m_systemState);
        this.m_interpreter.exec("class ___DieQuietly___: pass");
        this.m_dieQuietly = (PyClass)this.m_interpreter.get("___DieQuietly___");
        try {
            version = PySystemState.class.getField("version").get(null).toString();
        }
        catch (Exception e) {
            version = "Unknown";
        }
        this.m_version = version;
        this.m_systemState.path.insert(0, (PyObject)new PyString(script.getFile().getParent()));
        this.m_systemState.path.insert(1, (PyObject)new PyString(script.getDirectory().getFile().getPath()));
        try {
            this.m_interpreter.execfile(script.getFile().getPath());
        }
        catch (PyException e) {
            throw new JythonScriptExecutionException("initialising test script", e);
        }
        this.m_testRunnerFactory = this.m_interpreter.get(TEST_RUNNER_CALLABLE_NAME);
        if (this.m_testRunnerFactory == null || !this.m_testRunnerFactory.isCallable()) {
            throw new JythonScriptExecutionException("There is no callable (class or function) named 'TestRunner' in " + script);
        }
    }

    private static File findFileInPath(String path, String fileName) {
        for (String pathEntry : path.split(File.pathSeparator)) {
            File file = new File(pathEntry);
            if (!file.exists() || !file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    @Override
    public ScriptEngineService.WorkerRunnable createWorkerRunnable() throws EngineException {
        PyObject pyTestRunner;
        try {
            pyTestRunner = this.m_testRunnerFactory.__call__();
        }
        catch (PyException e) {
            throw new JythonScriptExecutionException("creating per-thread TestRunner object", e);
        }
        if (!pyTestRunner.isCallable()) {
            throw new JythonScriptExecutionException("The result of 'TestRunner()' is not callable");
        }
        return new JythonWorkerRunnable(pyTestRunner);
    }

    @Override
    public ScriptEngineService.WorkerRunnable createWorkerRunnable(Object testRunner) throws EngineException {
        PyObject pyTestRunner;
        if (testRunner instanceof PyObject && (pyTestRunner = (PyObject)testRunner).isCallable()) {
            return new JythonWorkerRunnable(pyTestRunner);
        }
        throw new JythonScriptExecutionException("testRunner object is not callable");
    }

    @Override
    public void shutdown() throws EngineException {
        PyObject exitfunc = this.m_systemState.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException e) {
                throw new JythonScriptExecutionException("calling script exit function", e);
            }
        }
    }

    @Override
    public String getDescription() {
        return "Jython " + this.m_version;
    }

    private final class JythonWorkerRunnable
    implements ScriptEngineService.WorkerRunnable {
        private final PyObject m_testRunner;

        public JythonWorkerRunnable(PyObject testRunner) {
            this.m_testRunner = testRunner;
        }

        @Override
        public void run() throws ScriptExecutionException {
            try {
                this.m_testRunner.__call__();
            }
            catch (PyException e) {
                throw new JythonScriptExecutionException("calling TestRunner", e);
            }
        }

        @Override
        public void shutdown() throws ScriptExecutionException {
            PyObject del = this.m_testRunner.__findattr__("__del__");
            if (del != null) {
                try {
                    del.__call__();
                }
                catch (PyException e) {
                    throw new JythonScriptExecutionException("deleting TestRunner instance", e);
                }
                finally {
                    this.m_testRunner.__setattr__("__class__", (PyObject)JythonScriptEngine.this.m_dieQuietly);
                }
            }
        }
    }
}

