/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process.dcr;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.grinder.engine.process.dcr.RecorderLocator;
import net.grinder.engine.process.dcr.RecorderRegistry;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Recorder;
import net.grinder.util.weave.Weaver;
import net.grinder.util.weave.WeavingException;
import net.grinder.util.weave.agent.ExposeInstrumentation;
import net.grinder.util.weave.j2se6.ASMTransformerFactory;
import net.grinder.util.weave.j2se6.DCRWeaver;
import org.slf4j.Logger;

public final class DCRContextImplementation
implements DCRContext {
    private static final String[] NON_INSTRUMENTABLE_PACKAGES = new String[]{"net.grinder.engine.process", "extra166y", "org.objectweb.asm"};
    private static final ClassLoader BOOTSTRAP_CLASSLOADER = Object.class.getClassLoader();
    private final Weaver m_weaver;
    private final RecorderRegistry m_recorderRegistry;

    public static DCRContextImplementation create(Logger logger) {
        Instrumentation instrumentation = ExposeInstrumentation.getInstrumentation();
        try {
            Method m = Instrumentation.class.getMethod("isRetransformClassesSupported", new Class[0]);
            if (!((Boolean)m.invoke((Object)instrumentation, new Object[0])).booleanValue()) {
                logger.info("Java VM does not support class retransformation, DCR unavailable");
                return null;
            }
        }
        catch (Exception e1) {
            logger.info("Java VM does not support instrumentation, DCR unavailable");
            return null;
        }
        return new DCRContextImplementation(instrumentation, RecorderLocator.class, RecorderLocator.getRecorderRegistry());
    }

    DCRContextImplementation(Instrumentation instrumentation, Class<?> recorderLocatorClass, RecorderRegistry recorderRegistry) {
        ASMTransformerFactory transformerFactory;
        try {
            transformerFactory = new ASMTransformerFactory(recorderLocatorClass);
        }
        catch (WeavingException e) {
            throw new AssertionError((Object)e);
        }
        this.m_weaver = new DCRWeaver(transformerFactory, instrumentation);
        this.m_recorderRegistry = recorderRegistry;
    }

    @Override
    public void add(Object target, Constructor<?> constructor, Recorder recorder) throws NonInstrumentableTypeException {
        this.checkWrappable(constructor.getDeclaringClass());
        String location = this.m_weaver.weave(constructor);
        this.m_recorderRegistry.register(target, location, recorder);
    }

    @Override
    public void add(Object target, Method method, Weaver.TargetSource targetSource, Recorder recorder) throws NonInstrumentableTypeException {
        this.checkWrappable(method.getDeclaringClass());
        try {
            String location = this.m_weaver.weave(method, targetSource);
            this.m_recorderRegistry.register(target, location, recorder);
        }
        catch (WeavingException e) {
            throw new NonInstrumentableTypeException("Weaving failed", e);
        }
    }

    private void checkWrappable(Class<?> theClass) throws NonInstrumentableTypeException {
        String whyNot = this.whyCantIInstrument(theClass);
        if (whyNot != null) {
            throw new NonInstrumentableTypeException("Cannot instrument " + theClass + " because " + whyNot);
        }
    }

    private String whyCantIInstrument(Class<?> targetClass) {
        if (targetClass.getClassLoader() == BOOTSTRAP_CLASSLOADER) {
            return "it belongs to the bootstrap classloader";
        }
        if ("net.grinder.engine.process.ExternalLogger".equals(targetClass.getName())) {
            return null;
        }
        Package thePackage = targetClass.getPackage();
        if (thePackage != null) {
            String packageName = thePackage.getName();
            for (String prefix : NON_INSTRUMENTABLE_PACKAGES) {
                if (!packageName.startsWith(prefix)) continue;
                return "it belongs to the " + prefix + " package";
            }
        }
        return null;
    }

    @Override
    public boolean isInstrumentable(Class<?> targetClass) {
        return this.whyCantIInstrument(targetClass) == null;
    }

    @Override
    public void applyChanges() throws WeavingException {
        this.m_weaver.applyChanges();
    }
}

