/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.Test;
import net.grinder.engine.process.DataLogArguments;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;
import org.slf4j.Logger;

class ThreadDataLogger {
    private static final String SEPARATOR = ", ";
    private final Logger m_dataLog;
    private final ExpressionView[] m_expressionViews;
    private final int m_threadNumber;
    private final StringBuilder m_buffer = new StringBuilder();
    private final int m_bufferAfterThreadIDIndex;
    private int m_bufferAfterRunNumberIndex = -1;
    private int m_lastRunNumber = -1;

    public ThreadDataLogger(Logger dataLog, ExpressionView[] expressionViews, int threadNumber) {
        this.m_dataLog = dataLog;
        this.m_expressionViews = expressionViews;
        this.m_threadNumber = threadNumber;
        this.m_buffer.append(threadNumber);
        this.m_buffer.append(SEPARATOR);
        this.m_bufferAfterThreadIDIndex = this.m_buffer.length();
    }

    public void report(int runNumber, Test test, long timeSinceExecutionStart, StatisticsSet statistics) {
        if (runNumber == this.m_lastRunNumber && this.m_lastRunNumber != -1) {
            this.m_buffer.setLength(this.m_bufferAfterRunNumberIndex);
        } else {
            this.m_lastRunNumber = runNumber;
            this.m_buffer.setLength(this.m_bufferAfterThreadIDIndex);
            this.m_buffer.append(runNumber);
            this.m_buffer.append(SEPARATOR);
            this.m_bufferAfterRunNumberIndex = this.m_buffer.length();
        }
        this.m_buffer.append(test.getNumber());
        this.m_buffer.append(SEPARATOR);
        this.m_buffer.append(timeSinceExecutionStart);
        for (ExpressionView expressionView : this.m_expressionViews) {
            this.m_buffer.append(SEPARATOR);
            StatisticExpression expression = expressionView.getExpression();
            if (expression.isDouble()) {
                this.m_buffer.append(expression.getDoubleValue(statistics));
                continue;
            }
            this.m_buffer.append(expression.getLongValue(statistics));
        }
        this.m_dataLog.info(this.m_buffer.toString(), (Object)new DataLogArguments(this.m_threadNumber, runNumber, test, timeSinceExecutionStart, statistics));
    }
}

