/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.grinder.common.Test;
import net.grinder.engine.process.TestData;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.script.TestRegistry;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.TimeAuthority;

final class TestRegistryImplementation
implements TestRegistry {
    private final ThreadContextLocator m_threadContextLocator;
    private final StatisticsSetFactory m_statisticsSetFactory;
    private final TestStatisticsHelper m_testStatisticsHelper;
    private final TimeAuthority m_timeAuthority;
    private final TestStatisticsMap m_testStatisticsMap;
    private final Map<Test, TestData> m_testMap = new TreeMap<Test, TestData>();
    private Collection<Test> m_newTests = null;
    private Instrumenter m_instrumenter;

    TestRegistryImplementation(ThreadContextLocator threadContextLocator, StatisticsSetFactory statisticsSetFactory, TestStatisticsHelper testStatisticsHelper, TimeAuthority timeAuthority) {
        this.m_threadContextLocator = threadContextLocator;
        this.m_statisticsSetFactory = statisticsSetFactory;
        this.m_testStatisticsHelper = testStatisticsHelper;
        this.m_timeAuthority = timeAuthority;
        this.m_testStatisticsMap = new TestStatisticsMap(this.m_statisticsSetFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRegistry.RegisteredTest register(Test test) {
        TestData newTestData;
        if (this.m_instrumenter == null) {
            throw new AssertionError((Object)"Instrumenter not set");
        }
        TestRegistryImplementation testRegistryImplementation = this;
        synchronized (testRegistryImplementation) {
            TestData existing = this.m_testMap.get(test);
            if (existing != null) {
                return existing;
            }
            newTestData = new TestData(this.m_threadContextLocator, this.m_statisticsSetFactory, this.m_testStatisticsHelper, this.m_timeAuthority, this.m_instrumenter, test);
            this.m_testMap.put(test, newTestData);
            this.m_testStatisticsMap.put(test, newTestData.getTestStatistics());
            if (this.m_newTests == null) {
                this.m_newTests = new ArrayList<Test>();
            }
            this.m_newTests.add(test);
        }
        return newTestData;
    }

    void setInstrumenter(Instrumenter instrumenter) {
        this.m_instrumenter = instrumenter;
    }

    TestStatisticsMap getTestStatisticsMap() {
        return this.m_testStatisticsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Test> getNewTests() {
        TestRegistryImplementation testRegistryImplementation = this;
        synchronized (testRegistryImplementation) {
            Collection<Test> collection;
            try {
                collection = this.m_newTests;
                this.m_newTests = null;
            }
            catch (Throwable throwable) {
                this.m_newTests = null;
                throw throwable;
            }
            return collection;
        }
    }
}

