/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.GrinderException;
import net.grinder.communication.Sender;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.messages.console.RegisterExpressionViewMessage;
import net.grinder.script.InvalidContextException;
import net.grinder.script.Statistics;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsServicesImplementation;

final class ScriptStatisticsImplementation
implements Statistics {
    private final ThreadContextLocator m_threadContextLocator;
    private final StatisticsServices m_statisticsServices;
    private final Sender m_consoleSender;

    public ScriptStatisticsImplementation(ThreadContextLocator threadContextLocator, StatisticsServices statisticsServices, Sender consoleSender) {
        this.m_threadContextLocator = threadContextLocator;
        this.m_statisticsServices = statisticsServices;
        this.m_consoleSender = consoleSender;
    }

    @Override
    public void setDelayReports(boolean b) throws InvalidContextException {
        this.getThreadContext().setDelayReports(b);
    }

    @Override
    public void report() throws InvalidContextException {
        this.getThreadContext().reportPendingDispatchContext();
    }

    private ThreadContext getThreadContext() throws InvalidContextException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new InvalidContextException("Statistics interface is only supported for worker threads.");
        }
        return threadContext;
    }

    @Override
    public boolean isTestInProgress() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        return threadContext != null && threadContext.getStatisticsForCurrentTest() != null;
    }

    @Override
    public void registerSummaryExpression(String displayName, String expression) throws GrinderException {
        ExpressionView expressionView = StatisticsServicesImplementation.getInstance().getStatisticExpressionFactory().createExpressionView(displayName, expression, false);
        this.m_statisticsServices.getSummaryStatisticsView().add(expressionView);
        this.m_consoleSender.send(new RegisterExpressionViewMessage(expressionView));
    }

    @Override
    public void registerDataLogExpression(String displayName, String expression) throws GrinderException {
        if (this.m_threadContextLocator.get() != null) {
            throw new InvalidContextException("registerDataLogExpression() is not supported from worker threads");
        }
        this.m_statisticsServices.getDetailStatisticsView().add(StatisticsServicesImplementation.getInstance().getStatisticExpressionFactory().createExpressionView(displayName, expression, false));
    }

    @Override
    public Statistics.StatisticsForTest getForCurrentTest() throws InvalidContextException {
        Statistics.StatisticsForTest statisticsForCurrentTest = this.getThreadContext().getStatisticsForCurrentTest();
        if (statisticsForCurrentTest == null) {
            throw new InvalidContextException("There is no test in progress.");
        }
        return statisticsForCurrentTest;
    }

    @Override
    public Statistics.StatisticsForTest getForLastTest() throws InvalidContextException {
        Statistics.StatisticsForTest statisticsForLastTest = this.getThreadContext().getStatisticsForLastTest();
        if (statisticsForLastTest == null) {
            throw new InvalidContextException("No tests have been performed by this thread.");
        }
        return statisticsForLastTest;
    }
}

