/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.communication.CommunicationException;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.ThreadStarter;
import net.grinder.engine.process.ThreadStopper;
import net.grinder.script.Barrier;
import net.grinder.script.InternalScriptContext;
import net.grinder.script.InvalidContextException;
import net.grinder.script.SSLControl;
import net.grinder.script.Statistics;
import net.grinder.script.TestRegistry;
import net.grinder.synchronisation.BarrierGroups;
import net.grinder.synchronisation.BarrierImplementation;
import net.grinder.synchronisation.messages.BarrierIdentity;
import net.grinder.util.Sleeper;
import org.slf4j.Logger;

final class ScriptContextImplementation
implements InternalScriptContext {
    private final WorkerIdentity m_workerIdentity;
    private final WorkerIdentity m_firstWorkerIdentity;
    private final ThreadContextLocator m_threadContextLocator;
    private final GrinderProperties m_properties;
    private final Logger m_logger;
    private final Sleeper m_sleeper;
    private final SSLControl m_sslControl;
    private final Statistics m_scriptStatistics;
    private final TestRegistry m_testRegistry;
    private final ThreadStarter m_threadStarter;
    private final ThreadStopper m_threadStopper;
    private final BarrierGroups m_barrierGroups;
    private final BarrierIdentity.Factory m_barrierIdentityFactory;

    public ScriptContextImplementation(WorkerIdentity workerIdentity, WorkerIdentity firstWorkerIdentity, ThreadContextLocator threadContextLocator, GrinderProperties properties, Logger logger, Sleeper sleeper, SSLControl sslControl, Statistics scriptStatistics, TestRegistry testRegistry, ThreadStarter threadStarter, ThreadStopper threadStopper, BarrierGroups barrierGroups, BarrierIdentity.Factory barrierIdentityFactory) {
        this.m_workerIdentity = workerIdentity;
        this.m_firstWorkerIdentity = firstWorkerIdentity;
        this.m_threadContextLocator = threadContextLocator;
        this.m_properties = properties;
        this.m_logger = logger;
        this.m_sleeper = sleeper;
        this.m_sslControl = sslControl;
        this.m_scriptStatistics = scriptStatistics;
        this.m_testRegistry = testRegistry;
        this.m_threadStarter = threadStarter;
        this.m_threadStopper = threadStopper;
        this.m_barrierGroups = barrierGroups;
        this.m_barrierIdentityFactory = barrierIdentityFactory;
    }

    @Override
    public int getAgentNumber() {
        return this.m_workerIdentity.getAgentIdentity().getNumber();
    }

    @Override
    public String getProcessName() {
        return this.m_workerIdentity.getName();
    }

    @Override
    public int getProcessNumber() {
        return this.m_workerIdentity.getNumber();
    }

    @Override
    public int getFirstProcessNumber() {
        return this.m_firstWorkerIdentity.getNumber();
    }

    @Override
    public int getThreadNumber() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getThreadNumber();
        }
        return -1;
    }

    @Override
    public int getRunNumber() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getRunNumber();
        }
        return -1;
    }

    @Override
    public Logger getLogger() {
        return this.m_logger;
    }

    @Override
    public void sleep(long meanTime) throws GrinderException {
        this.m_sleeper.sleepNormal(meanTime);
    }

    @Override
    public void sleep(long meanTime, long sigma) throws GrinderException {
        this.m_sleeper.sleepNormal(meanTime, sigma);
    }

    @Override
    public int startWorkerThread() throws GrinderException {
        return this.m_threadStarter.startThread(null);
    }

    @Override
    public int startWorkerThread(Object testRunner) throws GrinderException {
        return this.m_threadStarter.startThread(testRunner);
    }

    @Override
    public void stopThisWorkerThread() throws InvalidContextException {
        if (this.m_threadContextLocator.get() != null) {
            throw new ShutdownException("Thread has been shut down");
        }
        throw new InvalidContextException("stopThisWorkerThread() must be called from  a worker thread");
    }

    @Override
    public boolean stopWorkerThread(int threadNumber) {
        return this.m_threadStopper.stopThread(threadNumber);
    }

    @Override
    public GrinderProperties getProperties() {
        return this.m_properties;
    }

    @Override
    public Statistics getStatistics() {
        return this.m_scriptStatistics;
    }

    @Override
    public SSLControl getSSLControl() {
        return this.m_sslControl;
    }

    @Override
    public TestRegistry getTestRegistry() {
        return this.m_testRegistry;
    }

    @Override
    public Barrier barrier(String name) throws CommunicationException {
        return new BarrierImplementation(this.m_barrierGroups.getGroup(name), this.m_barrierIdentityFactory);
    }
}

