/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.util.HashMap;
import java.util.Map;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ProcessLifeCycleListener;
import net.grinder.engine.process.RegisteredPlugin;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.plugininterface.GrinderPlugin;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginRegistry;
import net.grinder.script.Grinder;
import net.grinder.statistics.StatisticsServices;
import net.grinder.util.TimeAuthority;
import org.slf4j.Logger;

final class PluginRegistryImplementation
extends PluginRegistry
implements ProcessLifeCycleListener {
    private final Logger m_logger;
    private final Grinder.ScriptContext m_scriptContext;
    private final ThreadContextLocator m_threadContextLocator;
    private final StatisticsServices m_statisticsServices;
    private final TimeAuthority m_timeAuthority;
    private final Map<GrinderPlugin, RegisteredPlugin> m_plugins = new HashMap<GrinderPlugin, RegisteredPlugin>();

    PluginRegistryImplementation(Logger logger, Grinder.ScriptContext scriptContext, ThreadContextLocator threadContextLocator, StatisticsServices statisticsServices, TimeAuthority timeAuthority) {
        this.m_logger = logger;
        this.m_scriptContext = scriptContext;
        this.m_threadContextLocator = threadContextLocator;
        this.m_statisticsServices = statisticsServices;
        this.m_timeAuthority = timeAuthority;
        PluginRegistryImplementation.setInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(GrinderPlugin plugin) throws EngineException {
        Map<GrinderPlugin, RegisteredPlugin> map = this.m_plugins;
        synchronized (map) {
            if (!this.m_plugins.containsKey(plugin)) {
                RegisteredPlugin registeredPlugin = new RegisteredPlugin(plugin, this.m_scriptContext, this.m_threadContextLocator, this.m_statisticsServices, this.m_timeAuthority, this.m_logger);
                try {
                    plugin.initialize(registeredPlugin);
                }
                catch (PluginException e) {
                    throw new EngineException("An instance of the plug-in class '" + plugin.getClass().getName() + "' could not be initialised.", e);
                }
                this.m_plugins.put(plugin, registeredPlugin);
                this.m_logger.info("registered plug-in {}", (Object)plugin.getClass().getName());
            }
        }
    }

    @Override
    public void threadCreated(final ThreadContext threadContext) {
        threadContext.registerThreadLifeCycleListener(new SkeletonThreadLifeCycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginThread() {
                RegisteredPlugin[] registeredPlugins;
                Map map = PluginRegistryImplementation.this.m_plugins;
                synchronized (map) {
                    registeredPlugins = PluginRegistryImplementation.this.m_plugins.values().toArray(new RegisteredPlugin[PluginRegistryImplementation.this.m_plugins.size()]);
                }
                for (int i = 0; i < registeredPlugins.length; ++i) {
                    try {
                        registeredPlugins[i].createPluginThreadListener(threadContext);
                        continue;
                    }
                    catch (EngineException engineException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void threadStarted(ThreadContext threadContext) {
    }
}

