/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.grinder.common.GrinderBuild;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.common.Test;
import net.grinder.common.processidentity.ProcessReport;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.MessagePump;
import net.grinder.communication.QueuedSender;
import net.grinder.communication.QueuedSenderDecorator;
import net.grinder.communication.Receiver;
import net.grinder.engine.common.ConnectorFactory;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.communication.ConsoleListener;
import net.grinder.engine.messages.InitialiseGrinderMessage;
import net.grinder.engine.process.ExternalLogger;
import net.grinder.engine.process.GrinderThread;
import net.grinder.engine.process.PluginRegistryImplementation;
import net.grinder.engine.process.ProcessLifeCycleListener;
import net.grinder.engine.process.SSLControlImplementation;
import net.grinder.engine.process.ScriptContextImplementation;
import net.grinder.engine.process.ScriptEngineContainer;
import net.grinder.engine.process.ScriptStatisticsImplementation;
import net.grinder.engine.process.TestRegistryImplementation;
import net.grinder.engine.process.TestStatisticsHelperImplementation;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextImplementation;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.ThreadStarter;
import net.grinder.engine.process.ThreadStopper;
import net.grinder.engine.process.WorkerRunnableFactory;
import net.grinder.engine.process.WorkerThreadSynchronisation;
import net.grinder.engine.process.dcr.DCRContextImplementation;
import net.grinder.messages.console.RegisterTestsMessage;
import net.grinder.messages.console.ReportStatisticsMessage;
import net.grinder.messages.console.WorkerAddress;
import net.grinder.messages.console.WorkerProcessReportMessage;
import net.grinder.script.Grinder;
import net.grinder.script.InvalidContextException;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.ScriptExecutionException;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.statistics.StatisticsTable;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.synchronisation.AbstractBarrierGroups;
import net.grinder.synchronisation.BarrierIdentityGenerator;
import net.grinder.synchronisation.ClientBarrierGroups;
import net.grinder.synchronisation.LocalBarrierGroups;
import net.grinder.util.JVM;
import net.grinder.util.ListenerSupport;
import net.grinder.util.Sleeper;
import net.grinder.util.SleeperImplementation;
import net.grinder.util.StandardTimeAuthority;
import net.grinder.util.TimeAuthority;
import net.grinder.util.thread.BooleanCondition;
import net.grinder.util.thread.Condition;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrinderProcess {
    private final Logger m_terminalLogger;
    private final Logger m_logger;
    private final Logger m_dataLogger;
    private final LoggerContext m_logbackLoggerContext;
    private final boolean m_reportTimesToConsole;
    private final QueuedSender m_consoleSender;
    private final Sleeper m_sleeper;
    private final InitialiseGrinderMessage m_initialisationMessage;
    private final ConsoleListener m_consoleListener;
    private final StatisticsServices m_statisticsServices;
    private final TestStatisticsMap m_accumulatedStatistics;
    private final TestStatisticsHelperImplementation m_testStatisticsHelper;
    private final TestRegistryImplementation m_testRegistryImplementation;
    private final Condition m_eventSynchronisation = new Condition();
    private final MessagePump m_messagePump;
    private final ThreadStarter m_invalidThreadStarter = new InvalidThreadStarter();
    private final Times m_times = new Times();
    private final ThreadContexts m_threadContexts = new ThreadContexts();
    private final ListenerSupport<ProcessLifeCycleListener> m_processLifeCycleListeners = new ListenerSupport();
    private ThreadStarter m_threadStarter = this.m_invalidThreadStarter;
    private boolean m_shutdownTriggered;
    private boolean m_communicationShutdown;

    public GrinderProcess(Receiver agentReceiver) throws GrinderException {
        AbstractBarrierGroups barrierGroups;
        this.m_initialisationMessage = (InitialiseGrinderMessage)agentReceiver.waitForMessage();
        if (this.m_initialisationMessage == null) {
            throw new EngineException("No control stream from agent");
        }
        GrinderProperties properties = this.m_initialisationMessage.getProperties();
        WorkerIdentity workerIdentity = this.m_initialisationMessage.getWorkerIdentity();
        String workerName = workerIdentity.getName();
        String logDirectory = properties.getProperty("grinder.logDirectory", ".");
        this.m_terminalLogger = LoggerFactory.getLogger((String)workerName);
        this.m_reportTimesToConsole = properties.getBoolean("grinder.reportTimesToConsole", true);
        this.m_logbackLoggerContext = this.configureLogging(workerName, logDirectory);
        this.m_logger = LoggerFactory.getLogger((String)("worker." + workerName));
        this.m_dataLogger = LoggerFactory.getLogger((String)"data");
        this.m_logger.info("The Grinder version {}", (Object)GrinderBuild.getVersionString());
        this.m_logger.info(JVM.getInstance().toString());
        this.m_logger.info("time zone is {}", (Object)new SimpleDateFormat("z (Z)").format(new Date()));
        MessageDispatchSender messageDispatcher = new MessageDispatchSender();
        if (this.m_initialisationMessage.getReportToConsole()) {
            this.m_consoleSender = new QueuedSenderDecorator(ClientSender.connect(new ConnectorFactory(ConnectionType.WORKER).create(properties), new WorkerAddress(workerIdentity)));
            barrierGroups = new ClientBarrierGroups(this.m_consoleSender, messageDispatcher);
        } else {
            this.m_consoleSender = new NullQueuedSender();
            barrierGroups = new LocalBarrierGroups();
        }
        BarrierIdentityGenerator barrierIdentityGenerator = new BarrierIdentityGenerator(this.m_initialisationMessage.getWorkerIdentity());
        ThreadStarter delegatingThreadStarter = new ThreadStarter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startThread(Object testRunner) throws EngineException, InvalidContextException {
                ThreadStarter threadStarter;
                Condition condition = GrinderProcess.this.m_eventSynchronisation;
                synchronized (condition) {
                    threadStarter = GrinderProcess.this.m_threadStarter;
                }
                return threadStarter.startThread(testRunner);
            }
        };
        this.m_statisticsServices = StatisticsServicesImplementation.getInstance();
        this.m_accumulatedStatistics = new TestStatisticsMap(this.m_statisticsServices.getStatisticsSetFactory());
        this.m_testStatisticsHelper = new TestStatisticsHelperImplementation(this.m_statisticsServices.getStatisticsIndexMap());
        this.m_testRegistryImplementation = new TestRegistryImplementation(this.m_threadContexts, this.m_statisticsServices.getStatisticsSetFactory(), this.m_testStatisticsHelper, this.m_times.getTimeAuthority());
        ExternalLogger externalLogger = new ExternalLogger(this.m_logger, this.m_threadContexts);
        this.m_sleeper = new SleeperImplementation(this.m_times.getTimeAuthority(), (Logger)externalLogger, properties.getDouble("grinder.sleepTimeFactor", 1.0), properties.getDouble("grinder.sleepTimeVariation", 0.2));
        ScriptStatisticsImplementation scriptStatistics = new ScriptStatisticsImplementation(this.m_threadContexts, this.m_statisticsServices, this.m_consoleSender);
        ThreadStopper threadStopper = new ThreadStopper(){

            @Override
            public boolean stopThread(int threadNumber) {
                return GrinderProcess.this.m_threadContexts.shutdown(threadNumber);
            }
        };
        ScriptContextImplementation scriptContext = new ScriptContextImplementation(workerIdentity, this.m_initialisationMessage.getFirstWorkerIdentity(), this.m_threadContexts, properties, (Logger)externalLogger, this.m_sleeper, new SSLControlImplementation(this.m_threadContexts), scriptStatistics, this.m_testRegistryImplementation, delegatingThreadStarter, threadStopper, barrierGroups, barrierIdentityGenerator);
        Grinder.grinder = scriptContext;
        PluginRegistryImplementation pluginRegistry = new PluginRegistryImplementation((Logger)externalLogger, scriptContext, this.m_threadContexts, this.m_statisticsServices, this.m_times.getTimeAuthority());
        this.m_processLifeCycleListeners.add(pluginRegistry);
        this.m_processLifeCycleListeners.add(this.m_threadContexts);
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.m_consoleListener = new ConsoleListener(this.m_eventSynchronisation, this.m_logger);
        this.m_consoleListener.registerMessageHandlers(messageDispatcher);
        this.m_messagePump = new MessagePump(agentReceiver, messageDispatcher, 1);
    }

    private LoggerContext configureLogging(String workerName, String logDirectory) throws EngineException {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory instanceof Context) {
            Context context = (Context)iLoggerFactory;
            LoggerContext result = (LoggerContext)iLoggerFactory;
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            context.putProperty("WORKER_NAME", workerName);
            context.putProperty("LOG_DIRECTORY", logDirectory);
            try {
                configurator.doConfigure(GrinderProcess.class.getResource("/logback-worker.xml"));
            }
            catch (JoranException e) {
                throw new EngineException("Could not initialise logger", e);
            }
            return result;
        }
        this.m_terminalLogger.warn("Logback not found; grinder log configuration will be ignored.\nConsider adding logback-classic to the start of the CLASSPATH.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws GrinderException {
        try {
            ExpressionView[] detailExpressionViews;
            GrinderProperties properties = this.m_initialisationMessage.getProperties();
            ScriptEngineContainer scriptEngineContainer = new ScriptEngineContainer(properties, this.m_logger, DCRContextImplementation.create(this.m_logger), this.m_initialisationMessage.getScript());
            WorkerIdentity workerIdentity = this.m_initialisationMessage.getWorkerIdentity();
            StringBuilder numbers = new StringBuilder("worker process ");
            numbers.append(workerIdentity.getNumber());
            int agentNumber = workerIdentity.getAgentIdentity().getNumber();
            if (agentNumber >= 0) {
                numbers.append(" of agent number ");
                numbers.append(agentNumber);
            }
            this.m_logger.info(numbers.toString());
            int numberOfThreads = properties.getShort("grinder.threads", (short)1);
            int reportToConsoleInterval = properties.getInt("grinder.reportToConsole.interval", 500);
            int duration = properties.getInt("grinder.duration", 0);
            Instrumenter instrumenter = scriptEngineContainer.createInstrumenter();
            this.m_testRegistryImplementation.setInstrumenter(instrumenter);
            this.m_logger.info("instrumentation agents: {}", (Object)instrumenter.getDescription());
            ScriptEngineService.ScriptEngine scriptEngine = scriptEngineContainer.getScriptEngine(this.m_initialisationMessage.getScript());
            this.m_logger.info("running \"{}\" using {}", (Object)this.m_initialisationMessage.getScript(), (Object)scriptEngine.getDescription());
            this.m_messagePump.start();
            StringBuilder dataLogHeader = new StringBuilder("Thread, Run, Test, Start time (ms since Epoch)");
            for (ExpressionView detailExpressionView : detailExpressionViews = this.m_statisticsServices.getDetailStatisticsView().getExpressionViews()) {
                dataLogHeader.append(", ");
                dataLogHeader.append(detailExpressionView.getDisplayName());
            }
            this.m_dataLogger.info(dataLogHeader.toString());
            this.sendStatusMessage(ProcessReport.State.STARTED, (short)0, (short)numberOfThreads);
            ThreadSynchronisation threadSynchronisation = new ThreadSynchronisation(this.m_eventSynchronisation);
            this.m_terminalLogger.info("starting threads");
            Condition len$ = this.m_eventSynchronisation;
            synchronized (len$) {
                this.m_threadStarter = new ThreadStarterImplementation(threadSynchronisation, scriptEngine);
                for (int i = 0; i < numberOfThreads; ++i) {
                    this.m_threadStarter.startThread(null);
                }
            }
            threadSynchronisation.startThreads();
            this.m_times.setExecutionStartTime();
            this.m_logger.info("start time is {} ms since Epoch", (Object)this.m_times.getExecutionStartTime());
            ReportToConsoleTimerTask reportTimerTask = new ReportToConsoleTimerTask(threadSynchronisation);
            ShutdownTimerTask shutdownTimerTask = new ShutdownTimerTask();
            ((TimerTask)reportTimerTask).run();
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)reportTimerTask, reportToConsoleInterval, (long)reportToConsoleInterval);
            try {
                if (duration > 0) {
                    this.m_terminalLogger.info("will shut down after {} ms", (Object)duration);
                    timer.schedule((TimerTask)shutdownTimerTask, duration);
                }
                Condition condition = this.m_eventSynchronisation;
                synchronized (condition) {
                    while (!threadSynchronisation.isFinished() && !this.m_consoleListener.checkForMessage(14)) {
                        if (this.m_shutdownTriggered) {
                            this.m_terminalLogger.info("specified duration exceeded, shutting down");
                            break;
                        }
                        this.m_eventSynchronisation.waitNoInterrruptException();
                    }
                }
                condition = this.m_eventSynchronisation;
                synchronized (condition) {
                    if (!threadSynchronisation.isFinished()) {
                        this.m_terminalLogger.info("waiting for threads to terminate");
                        this.m_threadStarter = this.m_invalidThreadStarter;
                        this.m_threadContexts.shutdownAll();
                        SleeperImplementation.shutdownAllCurrentSleepers();
                        long time = System.currentTimeMillis();
                        long maximumShutdownTime = 10000L;
                        while (!threadSynchronisation.isFinished()) {
                            if (System.currentTimeMillis() - time > 10000L) {
                                this.m_terminalLogger.info("ignoring unresponsive threads");
                                break;
                            }
                            this.m_eventSynchronisation.waitNoInterrruptException(10000L);
                        }
                    }
                }
            }
            finally {
                reportTimerTask.cancel();
                shutdownTimerTask.cancel();
            }
            scriptEngine.shutdown();
            ((TimerTask)reportTimerTask).run();
            if (!this.m_communicationShutdown) {
                this.sendStatusMessage(ProcessReport.State.FINISHED, (short)0, (short)0);
            }
            this.m_consoleSender.shutdown();
            long elapsedTime = this.m_times.getElapsedTime();
            this.m_logger.info("elapsed time is {} ms", (Object)elapsedTime);
            this.m_logger.info("Final statistics for this process:");
            StatisticsTable statisticsTable = new StatisticsTable(this.m_statisticsServices.getSummaryStatisticsView(), this.m_statisticsServices.getStatisticsIndexMap(), this.m_accumulatedStatistics);
            StringWriter statistics = new StringWriter();
            statistics.write("\n");
            statisticsTable.print(new PrintWriter(statistics), elapsedTime);
            this.m_logger.info(statistics.toString());
            timer.cancel();
            this.m_terminalLogger.info("finished");
        }
        catch (ScriptExecutionException e) {
            this.m_logger.error("aborting process - {}", (Object)e.getShortMessage(), (Object)e);
            this.m_terminalLogger.error("aborting process - {}", (Object)e.getShortMessage(), (Object)e);
        }
    }

    public void shutdown(boolean inputStreamIsStdin) {
        if (!inputStreamIsStdin) {
            this.m_messagePump.shutdown();
        }
        if (this.m_logbackLoggerContext != null) {
            this.m_logbackLoggerContext.stop();
        }
    }

    private void sendStatusMessage(ProcessReport.State finished, short numberOfThreads, short totalNumberOfThreads) throws CommunicationException {
        this.m_consoleSender.send(new WorkerProcessReportMessage(finished, numberOfThreads, totalNumberOfThreads));
        this.m_consoleSender.flush();
    }

    static final class NullQueuedSender
    implements QueuedSender {
        NullQueuedSender() {
        }

        @Override
        public void send(Message message) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void shutdown() {
        }
    }

    static final class ThreadContexts
    implements ProcessLifeCycleListener,
    ThreadContextLocator {
        private final ThreadLocal<ThreadContext> m_threadContextThreadLocal = new ThreadLocal();
        private final Map<Integer, ThreadContext> m_threadContextsMap = new HashMap<Integer, ThreadContext>();
        private boolean m_allShutdown;

        ThreadContexts() {
        }

        @Override
        public ThreadContext get() {
            return this.m_threadContextThreadLocal.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadCreated(ThreadContext threadContext) {
            boolean shutdown;
            final Integer threadNumber = threadContext.getThreadNumber();
            Map<Integer, ThreadContext> map = this.m_threadContextsMap;
            synchronized (map) {
                shutdown = this.m_allShutdown;
                if (!shutdown) {
                    threadContext.registerThreadLifeCycleListener(new SkeletonThreadLifeCycleListener(){

                        @Override
                        public void endThread() {
                            ThreadContexts.this.m_threadContextsMap.remove(threadNumber);
                        }
                    });
                    this.m_threadContextsMap.put(threadNumber, threadContext);
                }
            }
            if (shutdown) {
                threadContext.shutdown();
            }
        }

        @Override
        public void threadStarted(ThreadContext threadContext) {
            this.m_threadContextThreadLocal.set(threadContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shutdown(int threadNumber) {
            ThreadContext threadContext;
            Map<Integer, ThreadContext> map = this.m_threadContextsMap;
            synchronized (map) {
                threadContext = this.m_threadContextsMap.get(threadNumber);
            }
            if (threadContext != null) {
                threadContext.shutdown();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAll() {
            ThreadContext[] threadContexts;
            Map<Integer, ThreadContext> map = this.m_threadContextsMap;
            synchronized (map) {
                this.m_allShutdown = true;
                threadContexts = this.m_threadContextsMap.values().toArray(new ThreadContext[this.m_threadContextsMap.size()]);
            }
            for (ThreadContext threadContext : threadContexts) {
                threadContext.shutdown();
            }
        }
    }

    static final class Times {
        private volatile long m_executionStartTime;
        private final TimeAuthority m_timeAuthority = new StandardTimeAuthority();

        Times() {
        }

        public void setExecutionStartTime() {
            this.m_executionStartTime = this.m_timeAuthority.getTimeInMilliseconds();
        }

        public long getExecutionStartTime() {
            return this.m_executionStartTime;
        }

        public long getElapsedTime() {
            return this.m_timeAuthority.getTimeInMilliseconds() - this.getExecutionStartTime();
        }

        public TimeAuthority getTimeAuthority() {
            return this.m_timeAuthority;
        }
    }

    static final class InvalidThreadStarter
    implements ThreadStarter {
        InvalidThreadStarter() {
        }

        @Override
        public int startThread(Object testRunner) throws InvalidContextException {
            throw new InvalidContextException("You should not start worker threads until the main thread has initialised the script engine, or after all other threads have shut down. Typically, you should only call startWorkerThread() from another worker thread.");
        }
    }

    private final class ThreadStarterImplementation
    implements ThreadStarter {
        private final ThreadSynchronisation m_threadSynchronisation;
        private final ScriptEngineService.ScriptEngine m_scriptEngine;
        private final WorkerRunnableFactory m_defaultWorkerRunnableFactory;
        private final ProcessLifeCycleListener m_threadLifeCycleCallbacks = new ProcessLifeCycleListener(){

            @Override
            public void threadCreated(final ThreadContext threadContext) {
                GrinderProcess.this.m_processLifeCycleListeners.apply(new ListenerSupport.Informer<ProcessLifeCycleListener>(){

                    @Override
                    public void inform(ProcessLifeCycleListener listener) {
                        listener.threadCreated(threadContext);
                    }
                });
            }

            @Override
            public void threadStarted(final ThreadContext threadContext) {
                GrinderProcess.this.m_processLifeCycleListeners.apply(new ListenerSupport.Informer<ProcessLifeCycleListener>(){

                    @Override
                    public void inform(ProcessLifeCycleListener listener) {
                        listener.threadStarted(threadContext);
                    }
                });
            }
        };
        private int m_i = -1;

        private ThreadStarterImplementation(ThreadSynchronisation threadSynchronisation, ScriptEngineService.ScriptEngine scriptEngine) {
            this.m_threadSynchronisation = threadSynchronisation;
            this.m_scriptEngine = scriptEngine;
            this.m_defaultWorkerRunnableFactory = new WorkerRunnableFactory(){

                @Override
                public ScriptEngineService.WorkerRunnable create() throws EngineException {
                    return ThreadStarterImplementation.this.m_scriptEngine.createWorkerRunnable();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startThread(final Object testRunner) throws EngineException {
            int threadNumber;
            ThreadStarterImplementation threadStarterImplementation = this;
            synchronized (threadStarterImplementation) {
                threadNumber = ++this.m_i;
            }
            ThreadContextImplementation threadContext = new ThreadContextImplementation(GrinderProcess.this.m_initialisationMessage.getProperties(), GrinderProcess.this.m_statisticsServices, threadNumber, GrinderProcess.this.m_dataLogger);
            WorkerRunnableFactory workerRunnableFactory = testRunner != null ? new WorkerRunnableFactory(){

                @Override
                public ScriptEngineService.WorkerRunnable create() throws EngineException {
                    return ThreadStarterImplementation.this.m_scriptEngine.createWorkerRunnable(testRunner);
                }
            } : this.m_defaultWorkerRunnableFactory;
            GrinderThread runnable = new GrinderThread(GrinderProcess.this.m_logger, threadContext, this.m_threadSynchronisation, this.m_threadLifeCycleCallbacks, GrinderProcess.this.m_initialisationMessage.getProperties(), GrinderProcess.this.m_sleeper, workerRunnableFactory);
            Thread t = new Thread((Runnable)runnable, "thread " + threadNumber);
            t.setDaemon(true);
            t.start();
            return threadNumber;
        }
    }

    static class ThreadSynchronisation
    implements WorkerThreadSynchronisation {
        private final BooleanCondition m_started = new BooleanCondition();
        private final Condition m_threadEventCondition;
        private short m_numberCreated = 0;
        private short m_numberAwaitingStart = 0;
        private short m_numberFinished = 0;

        ThreadSynchronisation(Condition condition) {
            this.m_threadEventCondition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short getNumberOfRunningThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return (short)(this.m_numberCreated - this.m_numberFinished);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isReadyToStart() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return this.m_numberAwaitingStart >= this.getNumberOfRunningThreads();
            }
        }

        public boolean isFinished() {
            return this.getNumberOfRunningThreads() <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short getTotalNumberOfThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                return this.m_numberCreated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadCreated() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberCreated = (short)(this.m_numberCreated + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startThreads() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                while (!this.isReadyToStart()) {
                    this.m_threadEventCondition.waitNoInterrruptException();
                }
                this.m_numberAwaitingStart = 0;
            }
            this.m_started.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void awaitStart() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberAwaitingStart = (short)(this.m_numberAwaitingStart + 1);
                if (this.isReadyToStart()) {
                    this.m_threadEventCondition.notifyAll();
                }
            }
            this.m_started.await(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadFinished() {
            Condition condition = this.m_threadEventCondition;
            synchronized (condition) {
                this.m_numberFinished = (short)(this.m_numberFinished + 1);
                if (this.isReadyToStart() || this.isFinished()) {
                    this.m_threadEventCondition.notifyAll();
                }
            }
        }
    }

    private class ShutdownTimerTask
    extends TimerTask {
        private ShutdownTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Condition condition = GrinderProcess.this.m_eventSynchronisation;
            synchronized (condition) {
                GrinderProcess.this.m_shutdownTriggered = true;
                GrinderProcess.this.m_eventSynchronisation.notifyAll();
            }
        }
    }

    private class ReportToConsoleTimerTask
    extends TimerTask {
        private final ThreadSynchronisation m_threads;

        public ReportToConsoleTimerTask(ThreadSynchronisation threads) {
            this.m_threads = threads;
        }

        @Override
        public void run() {
            if (!GrinderProcess.this.m_communicationShutdown) {
                try {
                    TestStatisticsMap sample = GrinderProcess.this.m_testRegistryImplementation.getTestStatisticsMap().reset();
                    GrinderProcess.this.m_accumulatedStatistics.add(sample);
                    Collection<Test> newTests = GrinderProcess.this.m_testRegistryImplementation.getNewTests();
                    if (newTests != null) {
                        GrinderProcess.this.m_consoleSender.send(new RegisterTestsMessage(newTests));
                    }
                    if (sample.size() > 0) {
                        if (!GrinderProcess.this.m_reportTimesToConsole) {
                            GrinderProcess.this.m_testStatisticsHelper.removeTestTimeFromSample(sample);
                        }
                        GrinderProcess.this.m_consoleSender.send(new ReportStatisticsMessage(sample));
                    }
                    GrinderProcess.this.sendStatusMessage(ProcessReport.State.RUNNING, this.m_threads.getNumberOfRunningThreads(), this.m_threads.getTotalNumberOfThreads());
                }
                catch (CommunicationException e) {
                    GrinderProcess.this.m_terminalLogger.info("Report to console failed", (Throwable)e);
                    GrinderProcess.this.m_communicationShutdown = true;
                }
            }
        }
    }
}

