/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;

final class ExternalLogger
extends MarkerIgnoringBase {
    private final Logger m_delegate;
    private final ThreadContextLocator m_threadContextLocator;

    public ExternalLogger(Logger processLogger, ThreadContextLocator threadContextLocator) {
        this.m_delegate = processLogger;
        this.m_threadContextLocator = threadContextLocator;
    }

    private Marker getMarker() {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext != null) {
            return threadContext.getLogMarker();
        }
        return null;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled(this.getMarker());
    }

    public void trace(String msg) {
        this.m_delegate.trace(this.getMarker(), msg);
    }

    public void trace(String format, Object arg) {
        this.m_delegate.trace(this.getMarker(), format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.m_delegate.trace(this.getMarker(), format, arg1, arg2);
    }

    public void trace(String format, Object[] argArray) {
        this.m_delegate.trace(this.getMarker(), format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.m_delegate.trace(this.getMarker(), msg, t);
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled(this.getMarker());
    }

    public void debug(String msg) {
        this.m_delegate.debug(this.getMarker(), msg);
    }

    public void debug(String format, Object arg) {
        this.m_delegate.debug(this.getMarker(), format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.m_delegate.debug(this.getMarker(), format, arg1, arg2);
    }

    public void debug(String format, Object[] argArray) {
        this.m_delegate.debug(this.getMarker(), format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.m_delegate.debug(this.getMarker(), msg, t);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled(this.getMarker());
    }

    public void info(String msg) {
        this.m_delegate.info(this.getMarker(), msg);
    }

    public void info(String format, Object arg) {
        this.m_delegate.info(this.getMarker(), format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.m_delegate.info(this.getMarker(), format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.m_delegate.info(this.getMarker(), format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.m_delegate.info(this.getMarker(), msg, t);
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled(this.getMarker());
    }

    public void warn(String msg) {
        this.m_delegate.warn(this.getMarker(), msg);
    }

    public void warn(String format, Object arg) {
        this.m_delegate.warn(this.getMarker(), format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.m_delegate.warn(this.getMarker(), format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.m_delegate.warn(this.getMarker(), format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.m_delegate.warn(this.getMarker(), msg, t);
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled(this.getMarker());
    }

    public void error(String msg) {
        this.m_delegate.error(this.getMarker(), msg);
    }

    public void error(String format, Object arg) {
        this.m_delegate.error(this.getMarker(), format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.m_delegate.error(this.getMarker(), format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.m_delegate.error(this.getMarker(), format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.m_delegate.error(this.getMarker(), msg, t);
    }
}

