/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.communication;

import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.messages.agent.ResetGrinderMessage;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.util.thread.Condition;
import org.slf4j.Logger;

public final class ConsoleListener {
    public static final int START = 1;
    public static final int RESET = 2;
    public static final int STOP = 4;
    public static final int SHUTDOWN = 8;
    public static final int ANY = 15;
    private final Condition m_notifyOnMessage;
    private final Logger m_logger;
    private int m_messagesReceived = 0;
    private int m_lastMessagesReceived = 0;
    private StartGrinderMessage m_lastStartGrinderMessage;

    public ConsoleListener(Condition notifyOnMessage, Logger logger) {
        this.m_notifyOnMessage = notifyOnMessage;
        this.m_logger = logger;
    }

    public void shutdown() {
        this.setReceived(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessage() {
        while (!this.checkForMessage(15)) {
            Condition condition = this.m_notifyOnMessage;
            synchronized (condition) {
                this.m_notifyOnMessage.waitNoInterrruptException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForMessage(int mask) {
        ConsoleListener consoleListener = this;
        synchronized (consoleListener) {
            int intersection = this.m_messagesReceived & mask;
            try {
                this.m_lastMessagesReceived = intersection;
            }
            finally {
                this.m_messagesReceived ^= intersection;
            }
        }
        return this.received(mask | 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardMessages(int mask) {
        ConsoleListener consoleListener = this;
        synchronized (consoleListener) {
            this.m_lastMessagesReceived &= ~mask;
            this.m_messagesReceived &= ~mask;
        }
    }

    public synchronized boolean received(int mask) {
        return (this.m_lastMessagesReceived & mask) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReceived(int message) {
        Object object = this;
        synchronized (object) {
            this.m_messagesReceived |= message;
        }
        object = this.m_notifyOnMessage;
        synchronized (object) {
            this.m_notifyOnMessage.notifyAll();
        }
    }

    public void registerMessageHandlers(MessageDispatchRegistry messageDispatcher) {
        messageDispatcher.set(StartGrinderMessage.class, new AbstractMessageHandler<StartGrinderMessage>(){

            @Override
            public void handle(StartGrinderMessage message) {
                ConsoleListener.this.m_logger.info("received a start message");
                ConsoleListener.this.m_lastStartGrinderMessage = message;
                ConsoleListener.this.setReceived(1);
            }
        });
        messageDispatcher.set(StopGrinderMessage.class, new AbstractMessageHandler<StopGrinderMessage>(){

            @Override
            public void handle(StopGrinderMessage message) {
                ConsoleListener.this.m_logger.info("received a stop message");
                ConsoleListener.this.setReceived(4);
            }
        });
        messageDispatcher.set(ResetGrinderMessage.class, new AbstractMessageHandler<ResetGrinderMessage>(){

            @Override
            public void handle(ResetGrinderMessage message) {
                ConsoleListener.this.m_logger.info("received a reset message");
                ConsoleListener.this.setReceived(2);
            }
        });
    }

    public StartGrinderMessage getLastStartGrinderMessage() {
        return this.m_lastStartGrinderMessage;
    }

    private abstract class AbstractMessageHandler<T extends Message>
    implements MessageDispatchRegistry.Handler<T> {
        private AbstractMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            boolean shutdown;
            ConsoleListener consoleListener = ConsoleListener.this;
            synchronized (consoleListener) {
                shutdown = (ConsoleListener.this.m_messagesReceived & 8) == 0;
            }
            if (shutdown) {
                ConsoleListener.this.m_logger.info("communication shut down");
                ConsoleListener.this.setReceived(8);
            }
        }
    }
}

