/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.agent.CommandLine;
import net.grinder.engine.process.WorkerProcessEntryPoint;
import net.grinder.util.Directory;

final class WorkerProcessCommandLine
implements CommandLine {
    private static final Pattern AGENT_JAR_FILENAME_PATTERN = Pattern.compile("^grinder-dcr-agent-([\\d.]*)(-.*)?.jar$");
    private final Directory m_workingDirectory;
    private final List<String> m_command;
    private final int m_commandClassIndex;
    private static final Set<String> s_unquoted = new HashSet<String>(){
        {
            this.add("-classpath");
            this.add("-client");
            this.add("-cp");
            this.add("-jar");
            this.add("-server");
        }
    };

    public WorkerProcessCommandLine(GrinderProperties properties, Properties systemProperties, String jvmArguments, Directory workingDirectory) {
        this.m_workingDirectory = workingDirectory;
        this.m_command = new ArrayList<String>();
        this.m_command.add(properties.getProperty("grinder.jvm", "java"));
        List<File> systemClasspath = workingDirectory.rebasePath(systemProperties.getProperty("java.class.path", ""));
        File agent = WorkerProcessCommandLine.findAgentJarFile(systemClasspath);
        if (agent != null) {
            this.m_command.add("-javaagent:" + agent);
        }
        if (jvmArguments != null) {
            StringTokenizer tokenizer = new StringTokenizer(jvmArguments);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.m_command.add(token);
            }
        }
        String additionalClasspath = properties.getProperty("grinder.jvm.classpath");
        StringBuilder classpath = new StringBuilder();
        if (additionalClasspath != null) {
            classpath.append(additionalClasspath);
        }
        for (File f : systemClasspath) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparatorChar);
            }
            classpath.append(f.getPath());
        }
        if (classpath.length() > 0) {
            this.m_command.add("-classpath");
            this.m_command.add(classpath.toString());
        }
        this.m_commandClassIndex = this.m_command.size();
        this.m_command.add(WorkerProcessEntryPoint.class.getName());
    }

    @Override
    public Directory getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    @Override
    public List<String> getCommandList() {
        return this.m_command;
    }

    public String toString() {
        String[] commandArray = this.getCommandList().toArray(new String[0]);
        StringBuilder buffer = new StringBuilder(commandArray.length * 10);
        for (int j = 0; j < commandArray.length; ++j) {
            boolean shouldQuote;
            if (j != 0) {
                buffer.append(" ");
            }
            boolean bl = shouldQuote = j != 0 && j != this.m_commandClassIndex && !s_unquoted.contains(commandArray[j]);
            if (shouldQuote) {
                buffer.append("'");
            }
            buffer.append(commandArray[j]);
            if (!shouldQuote) continue;
            buffer.append("'");
        }
        return buffer.toString();
    }

    static boolean isAgentJar(String name) {
        Matcher matcher = AGENT_JAR_FILENAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            String maybeSnapshot = matcher.group(2);
            return maybeSnapshot == null || "-SNAPSHOT".equals(maybeSnapshot);
        }
        return false;
    }

    static File findAgentJarFile(List<File> systemClasspath) {
        for (File pathEntry : systemClasspath) {
            File f = pathEntry.getParentFile();
            File parentFile = f != null ? f : new File(".");
            File[] children = parentFile.listFiles();
            if (children == null) continue;
            for (File candidate : children) {
                if (!WorkerProcessCommandLine.isAgentJar(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }
}

