/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.engine.agent.CommandLine;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.common.EngineException;
import net.grinder.util.StreamCopier;

final class ProcessWorker
implements Worker {
    private final WorkerIdentity m_workerIdentity;
    private final Process m_process;
    private final Redirector m_stdoutRedirector;
    private final Redirector m_stderrRedirector;

    public ProcessWorker(WorkerIdentity workerIdentity, CommandLine commandLine, OutputStream outputStream, OutputStream errorStream) throws EngineException {
        this.m_workerIdentity = workerIdentity;
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine.getCommandList());
        processBuilder.directory(commandLine.getWorkingDirectory().getFile());
        try {
            this.m_process = processBuilder.start();
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new EngineException("Could not start process", e);
        }
        this.m_stdoutRedirector = new Redirector(this.m_process.getInputStream(), outputStream, this.m_process.toString());
        this.m_stderrRedirector = new Redirector(this.m_process.getErrorStream(), errorStream, this.m_process.toString());
    }

    @Override
    public WorkerIdentity getIdentity() {
        return this.m_workerIdentity;
    }

    @Override
    public OutputStream getCommunicationStream() {
        return this.m_process.getOutputStream();
    }

    @Override
    public int waitFor() {
        try {
            this.m_process.waitFor();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        finally {
            this.m_stdoutRedirector.stop();
            this.m_stderrRedirector.stop();
        }
        return this.m_process.exitValue();
    }

    @Override
    public void destroy() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        this.m_process.destroy();
    }

    private static class Redirector {
        private final Thread m_thread;

        public Redirector(InputStream inputStream, OutputStream outputStream, String processName) {
            this.m_thread = new Thread(new StreamCopier(4096, false).getRunnable(inputStream, outputStream), "Stream redirector for process " + processName);
            this.m_thread.setDaemon(true);
            this.m_thread.start();
        }

        public void stop() {
            while (this.m_thread.isAlive()) {
                try {
                    this.m_thread.join();
                }
                catch (InterruptedException e) {
                    throw new UncheckedInterruptedException(e);
                }
            }
        }
    }
}

