/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.grinder.common.GrinderProperties;
import net.grinder.communication.FanOutStreamSender;
import net.grinder.engine.agent.AbstractWorkerFactory;
import net.grinder.engine.agent.AgentIdentityImplementation;
import net.grinder.engine.agent.DebugThreadWorker;
import net.grinder.engine.agent.IsolatedGrinderProcessRunner;
import net.grinder.engine.agent.Worker;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.util.BlockingClassLoader;
import net.grinder.util.weave.agent.ExposeInstrumentation;

final class DebugThreadWorkerFactory
extends AbstractWorkerFactory {
    private static String s_isolatedRunnerClassName = IsolatedGrinderProcessRunner.class.getName();
    private final Set<String> m_isolatedClasses = Collections.singleton("*");
    private final Set<String> m_sharedClasses = new HashSet<String>();

    static void setIsolatedRunnerClass(String isolatedRunnerClassName) {
        s_isolatedRunnerClassName = isolatedRunnerClassName != null ? isolatedRunnerClassName : IsolatedGrinderProcessRunner.class.getName();
    }

    public DebugThreadWorkerFactory(AgentIdentityImplementation agentIdentity, FanOutStreamSender fanOutStreamSender, boolean reportToConsole, ScriptLocation script, GrinderProperties properties) throws EngineException {
        super(agentIdentity, fanOutStreamSender, reportToConsole, script, properties);
        this.m_sharedClasses.add(DebugThreadWorker.IsolateGrinderProcessRunner.class.getName());
        this.m_sharedClasses.add(ExposeInstrumentation.class.getName());
        String additionalSharedClasses = properties.getProperty("grinder.debug.singleprocess.sharedclasses");
        if (additionalSharedClasses != null) {
            this.m_sharedClasses.addAll(Arrays.asList(additionalSharedClasses.split(",")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Worker createWorker(AgentIdentityImplementation.WorkerIdentityImplementation workerIdentity, OutputStream outputStream, OutputStream errorStream) throws EngineException {
        DebugThreadWorker.IsolateGrinderProcessRunner runner;
        Class<?> isolatedRunnerClass;
        BlockingClassLoader classLoader = new BlockingClassLoader(Collections.<String>emptySet(), this.m_isolatedClasses, this.m_sharedClasses, true);
        try {
            isolatedRunnerClass = Class.forName(s_isolatedRunnerClassName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        try {
            runner = (DebugThreadWorker.IsolateGrinderProcessRunner)isolatedRunnerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineException("Failed to create IsolateGrinderProcessRunner", e);
        }
        catch (IllegalAccessException e) {
            throw new EngineException("Failed to create IsolateGrinderProcessRunner", e);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            DebugThreadWorker worker = new DebugThreadWorker(workerIdentity, runner);
            worker.start();
            DebugThreadWorker debugThreadWorker = worker;
            return debugThreadWorker;
        }
        finally {
            currentThread.setContextClassLoader(contextLoader);
        }
    }
}

