/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.agent;

import net.grinder.common.GrinderException;
import net.grinder.engine.agent.Agent;
import net.grinder.util.Sleeper;
import net.grinder.util.SleeperImplementation;
import net.grinder.util.StandardTimeAuthority;
import org.slf4j.Logger;

public final class AgentDaemon
implements Agent {
    private final Logger m_logger;
    private final long m_sleepTime;
    private final Agent m_delegateAgent;
    private final Sleeper m_sleeper;
    private final Thread m_shutdownHook;

    public AgentDaemon(Logger logger, long sleepTime, Agent agent) {
        this(logger, sleepTime, agent, new SleeperImplementation(new StandardTimeAuthority(), logger, 1.0, 0.0));
    }

    AgentDaemon(Logger logger, long sleepTime, Agent agent, Sleeper sleeper) {
        this.m_logger = logger;
        this.m_delegateAgent = agent;
        this.m_sleepTime = sleepTime;
        this.m_sleeper = sleeper;
        this.m_shutdownHook = new Thread(new ShutdownHook());
    }

    @Override
    public void run() throws GrinderException {
        Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
        try {
            while (true) {
                this.m_delegateAgent.run();
                this.m_logger.info("agent finished");
                this.m_sleeper.sleepNormal(this.m_sleepTime);
            }
        }
        catch (Sleeper.ShutdownException shutdownException) {
            return;
        }
    }

    @Override
    public void shutdown() {
        this.m_sleeper.shutdown();
        this.m_delegateAgent.shutdown();
    }

    Thread getShutdownHook() {
        return this.m_shutdownHook;
    }

    private class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            AgentDaemon.this.shutdown();
        }
    }
}

