/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.textui;

import java.util.Arrays;
import java.util.Comparator;
import net.grinder.common.GrinderBuild;
import net.grinder.common.processidentity.ProcessReport;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.console.ConsoleFoundation;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.ProcessReportDescriptionFactory;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.model.SampleModel;
import net.grinder.messages.console.AgentAndCacheReport;
import org.slf4j.Logger;

public class TextUI
implements ConsoleFoundation.UI {
    private final Logger m_logger;
    private final ErrorHandler m_errorHandler;
    private final Thread m_shutdownHook;
    private final SampleModel m_sampleModel;

    public TextUI(Resources resources, ProcessControl processControl, SampleModel sampleModel, Logger logger) {
        this.m_logger = logger;
        this.m_logger.info(GrinderBuild.getName());
        this.m_shutdownHook = new Thread(new ShutdownHook(resources));
        Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
        this.m_errorHandler = new ErrorHandlerImplementation();
        processControl.addProcessStatusListener(new ProcessListener(resources));
        this.m_sampleModel = sampleModel;
        this.m_sampleModel.addModelListener(new SampleModel.AbstractListener(){

            @Override
            public void stateChanged() {
                TextUI.this.m_logger.info(TextUI.this.m_sampleModel.getState().getDescription());
            }
        });
    }

    Thread getShutdownHook() {
        return this.m_shutdownHook;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    private final class ShutdownHook
    implements Runnable {
        private final String m_shutdownMessage;
        private boolean m_stopped = false;

        public ShutdownHook(Resources resources) {
            this.m_shutdownMessage = resources.getString("finished.text");
        }

        @Override
        public synchronized void run() {
            if (!this.m_stopped) {
                this.m_stopped = true;
                TextUI.this.m_logger.info(this.m_shutdownMessage);
            }
        }
    }

    private final class ErrorHandlerImplementation
    implements ErrorHandler {
        private ErrorHandlerImplementation() {
        }

        @Override
        public void handleErrorMessage(String errorMessage) {
            TextUI.this.m_logger.error(errorMessage);
        }

        @Override
        public void handleErrorMessage(String errorMessage, String title) {
            TextUI.this.m_logger.error("[" + title + "] " + errorMessage);
        }

        @Override
        public void handleException(Throwable throwable) {
            TextUI.this.m_logger.error(throwable.getMessage(), throwable);
        }

        @Override
        public void handleException(Throwable throwable, String title) {
            TextUI.this.m_logger.error(title, throwable);
        }

        @Override
        public void handleInformationMessage(String informationMessage) {
            TextUI.this.m_logger.info(informationMessage);
        }
    }

    private final class ProcessListener
    implements ProcessControl.Listener {
        private final Comparator<ProcessReport> m_processReportComparator = new ProcessReport.StateThenNameThenNumberComparator();
        private final Comparator<ProcessControl.ProcessReports> m_processReportsComparator = new ProcessControl.ProcessReportsComparator();
        private final ProcessReportDescriptionFactory m_descriptionFactory;
        private final String m_noConnectedAgents;
        private String m_lastReport = null;

        public ProcessListener(Resources resources) {
            this.m_descriptionFactory = new ProcessReportDescriptionFactory(resources);
            this.m_noConnectedAgents = resources.getString("noConnectedAgents.text");
        }

        @Override
        public void update(ProcessControl.ProcessReports[] processReports) {
            String reportString;
            if (processReports.length == 0) {
                reportString = this.m_noConnectedAgents;
            } else {
                StringBuilder report = new StringBuilder(processReports.length * 128);
                Arrays.sort(processReports, this.m_processReportsComparator);
                for (int i = 0; i < processReports.length; ++i) {
                    if (i > 0) {
                        report.append(", ");
                    }
                    AgentAndCacheReport agentProcessStatus = processReports[i].getAgentProcessReport();
                    report.append(this.m_descriptionFactory.create(agentProcessStatus).toString());
                    WorkerProcessReport[] workerProcessStatuses = processReports[i].getWorkerProcessReports();
                    if (workerProcessStatuses.length <= 0) continue;
                    report.append(" { ");
                    Arrays.sort(workerProcessStatuses, this.m_processReportComparator);
                    for (int j = 0; j < workerProcessStatuses.length; ++j) {
                        if (j > 0) {
                            report.append(", ");
                        }
                        report.append(this.m_descriptionFactory.create(workerProcessStatuses[j]).toString());
                    }
                    report.append(" }");
                }
                reportString = report.toString();
            }
            if (!reportString.equals(this.m_lastReport)) {
                TextUI.this.m_logger.info(reportString);
                this.m_lastReport = reportString;
            }
        }
    }
}

